/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.parallelapsp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Closeable;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPImpl;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.TestingThreadPoolServiceInterface;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolIfc;
import org.opendaylight.controller.config.spi.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TestingParallelAPSPModule
implements Module,
TestingParallelAPSPConfigMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(TestingParallelAPSPModule.class);
    private final DependencyResolver dependencyResolver;
    private final AutoCloseable oldCloseable;
    private final TestingParallelAPSPImpl oldInstance;
    private final ModuleIdentifier identifier;
    private ObjectName threadPoolON;
    private TestingParallelAPSPImpl instance;
    private String someParam;
    private final JmxAttribute threadPoolONJMXAttribute = new JmxAttribute("threadPoolON");

    public TestingParallelAPSPModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, @Nullable AutoCloseable oldCloseable, @Nullable TestingParallelAPSPImpl oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldCloseable = oldCloseable;
        this.oldInstance = oldInstance;
    }

    @Override
    public ObjectName getThreadPool() {
        return this.threadPoolON;
    }

    @Override
    @RequireInterface(value=TestingThreadPoolServiceInterface.class)
    public void setThreadPool(ObjectName threadPoolName) {
        this.threadPoolON = threadPoolName;
    }

    @Override
    public String getSomeParam() {
        return this.someParam;
    }

    @Override
    public void setSomeParam(String someParam) {
        this.someParam = someParam;
    }

    @Override
    public Integer getMaxNumberOfThreads() {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getMaxNumberOfThreads();
    }

    public void validate() {
        Preconditions.checkNotNull((Object)this.threadPoolON, (Object)"Parameter 'threadPool' must be set");
        this.dependencyResolver.validateDependency(TestingThreadPoolServiceInterface.class, this.threadPoolON, this.threadPoolONJMXAttribute);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.someParam) ? 1 : 0) != 0, (Object)"Parameter 'SomeParam' is blank");
        try {
            this.dependencyResolver.resolveInstance(TestingThreadPoolIfc.class, this.threadPoolON, this.threadPoolONJMXAttribute);
            throw new RuntimeException("fail");
        }
        catch (IllegalStateException e) {
            int threadCount;
            Preconditions.checkState((boolean)"Commit was not triggered".equals(e.getMessage()), (Object)e.getMessage());
            try {
                threadCount = (Integer)this.dependencyResolver.getAttribute(this.threadPoolON, "ThreadCount");
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2);
            }
            Preconditions.checkState((threadCount > 0 ? 1 : 0) != 0);
            TestingThreadPoolConfigMXBean proxy = (TestingThreadPoolConfigMXBean)this.dependencyResolver.newMXBeanProxy(this.threadPoolON, TestingThreadPoolConfigMXBean.class);
            Preconditions.checkState((threadCount == proxy.getThreadCount() ? 1 : 0) != 0);
            return;
        }
    }

    public Closeable getInstance() {
        if (this.instance == null) {
            TestingThreadPoolIfc threadPoolInstance = (TestingThreadPoolIfc)this.dependencyResolver.resolveInstance(TestingThreadPoolIfc.class, this.threadPoolON, this.threadPoolONJMXAttribute);
            if (this.oldInstance != null) {
                boolean reuse;
                boolean bl = reuse = threadPoolInstance == this.oldInstance.getThreadPool();
                if (reuse) {
                    LOG.debug("Reusing old instance");
                    this.instance = this.oldInstance;
                    this.instance.setSomeParam(this.someParam);
                }
            }
            if (this.instance == null) {
                LOG.debug("Creating new instance");
                if (this.oldCloseable != null) {
                    try {
                        this.oldCloseable.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.instance = new TestingParallelAPSPImpl(threadPoolInstance, this.someParam);
            }
        }
        return this.instance;
    }

    public boolean canReuse(Module oldModule) {
        return false;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }
}

