/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.threadpool;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.ModifiableThreadPoolServiceInterface;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.TestingThreadPoolServiceInterface;
import org.opendaylight.controller.config.manager.testingservices.threadpool.AbstractTestingFixedThreadPoolModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPool;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModule;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;

public class TestingFixedThreadPoolModuleFactory
extends AbstractTestingFixedThreadPoolModuleFactory
implements ModuleFactory {
    public static final String NAME = "fixed";
    private static final Set<Class<? extends AbstractServiceInterface>> ifc = ImmutableSet.of(ModifiableThreadPoolServiceInterface.class, TestingThreadPoolServiceInterface.class);

    public String getImplementationName() {
        return NAME;
    }

    public TestingFixedThreadPoolModule createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new TestingFixedThreadPoolModule(new ModuleIdentifier(NAME, instanceName), null, null);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        TestingFixedThreadPool oldInstance;
        int threadCount = (Integer)old.getAttribute("ThreadCount");
        try {
            oldInstance = (TestingFixedThreadPool)old.getInstance();
        }
        catch (ClassCastException e) {
            oldInstance = null;
        }
        TestingFixedThreadPoolModule result = new TestingFixedThreadPoolModule(new ModuleIdentifier(NAME, instanceName), old.getInstance(), oldInstance);
        result.setThreadCount(threadCount);
        return result;
    }

    public boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        return ifc.contains(serviceInterface);
    }

    public Set<Module> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<Module>();
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return ifc;
    }
}

