/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.threadpool.test;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.AbstractConfigTest;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPool;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModuleFactory;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class SimpleConfigurationTest
extends AbstractConfigTest {
    private static final int numberOfThreads = 5;
    private final int numberOfThreads2 = 10;
    private static final String fixed1 = "fixed1";
    private static final List<ObjectName> emptyONs = Collections.emptyList();
    private static final ObjectName platformFixed1ON = ObjectNameUtil.createReadOnlyModuleON((String)"fixed", (String)"fixed1");
    private static final List<ObjectName> fixed1List = Arrays.asList(platformFixed1ON);

    @Before
    public void setUp() {
        super.initConfigTransactionManagerImpl(new HardcodedModuleFactoriesResolver(this.mockedContext, new TestingFixedThreadPoolModuleFactory()));
    }

    @After
    public void tearDown() {
        TestingFixedThreadPool.cleanUp();
    }

    private ObjectName firstCommit() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName fixed1names = SimpleConfigurationTest.createFixedThreadPool(transaction);
        Assert.assertEquals((long)1L, (long)this.configRegistryClient.getOpenConfigs().size());
        CommitStatus commitStatus = transaction.commit();
        Assert.assertEquals((long)0L, (long)this.configRegistryClient.getOpenConfigs().size());
        CommitStatus expected = new CommitStatus(Arrays.asList(ObjectNameUtil.withoutTransactionName((ObjectName)fixed1names)), emptyONs, emptyONs);
        Assert.assertEquals((Object)expected, (Object)commitStatus);
        Assert.assertEquals((long)1L, (long)TestingFixedThreadPool.allExecutors.size());
        Assert.assertFalse((boolean)TestingFixedThreadPool.allExecutors.get(0).isShutdown());
        return fixed1names;
    }

    static ObjectName createFixedThreadPool(ConfigTransactionJMXClient transaction) throws InstanceAlreadyExistsException, InstanceNotFoundException {
        transaction.assertVersion(0, 1);
        ObjectName fixed1names = transaction.createModule("fixed", fixed1);
        TestingFixedThreadPoolConfigMXBean fixedConfigProxy = (TestingFixedThreadPoolConfigMXBean)transaction.newMXBeanProxy(fixed1names, TestingFixedThreadPoolConfigMXBean.class);
        fixedConfigProxy.setThreadCount(5);
        ObjectName retrievedNames = transaction.lookupConfigBean("fixed", fixed1);
        Assert.assertEquals((Object)fixed1names, (Object)retrievedNames);
        return fixed1names;
    }

    @Test
    public void testCreateAndDestroyBeanInSameTransaction() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName fixed1names = SimpleConfigurationTest.createFixedThreadPool(transaction);
        transaction.destroyModule(fixed1names);
        CommitStatus commitStatus = transaction.commit();
        this.assertStatus(commitStatus, 0, 0, 0);
    }

    @Test
    public void testValidationUsingJMXClient() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        this.testValidation((ConfigTransactionClient)transaction);
    }

    private void testValidation(ConfigTransactionClient transaction) throws InstanceAlreadyExistsException, ReflectionException, InstanceNotFoundException, MBeanException, ConflictingVersionException {
        ObjectName fixed1names = transaction.createModule("fixed", fixed1);
        try {
            platformMBeanServer.invoke(fixed1names, "validate", new Object[0], new String[0]);
            Assert.fail();
        }
        catch (MBeanException e) {
            Exception targetException = e.getTargetException();
            Assert.assertNotNull((Object)targetException);
            Assert.assertEquals(ValidationException.class, targetException.getClass());
        }
        try {
            transaction.validateBean(fixed1names);
            Assert.fail();
        }
        catch (ValidationException e) {
            for (Map.Entry exception : e.getFailedValidations().entrySet()) {
                for (Map.Entry entry : ((Map)exception.getValue()).entrySet()) {
                    Assert.assertEquals((Object)"Parameter 'threadCount' must be greater than 0", (Object)((ValidationException.ExceptionMessageWithStackTrace)entry.getValue()).getMessage());
                }
            }
        }
        try {
            transaction.validateConfig();
            Assert.fail();
        }
        catch (ValidationException e) {
            for (Map.Entry exception : e.getFailedValidations().entrySet()) {
                for (Map.Entry entry : ((Map)exception.getValue()).entrySet()) {
                    Assert.assertEquals((Object)"Parameter 'threadCount' must be greater than 0", (Object)((ValidationException.ExceptionMessageWithStackTrace)entry.getValue()).getMessage());
                }
            }
        }
        try {
            transaction.commit();
        }
        catch (ValidationException e) {
            for (Map.Entry exception : e.getFailedValidations().entrySet()) {
                for (Map.Entry entry : ((Map)exception.getValue()).entrySet()) {
                    Assert.assertEquals((Object)"Parameter 'threadCount' must be greater than 0", (Object)((ValidationException.ExceptionMessageWithStackTrace)entry.getValue()).getMessage());
                }
            }
        }
    }

    @Test
    public void test_createThreadPool_changeNumberOfThreads() throws Exception {
        this.firstCommit();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        TestingFixedThreadPoolConfigMXBean fixedConfigProxy = this.startReconfiguringFixed1ThreadPool(transaction);
        Assert.assertEquals((long)5L, (long)fixedConfigProxy.getThreadCount());
        fixedConfigProxy.setThreadCount(10);
        CommitStatus commitStatus = transaction.commit();
        this.checkThreadPools(1, 10);
        CommitStatus expected = new CommitStatus(emptyONs, fixed1List, emptyONs);
        Assert.assertEquals((Object)expected, (Object)commitStatus);
    }

    @Test
    public void test_createFixedThreadPool_destroyIt() throws Exception {
        ObjectName fixed1name = this.firstCommit();
        ObjectName on = ObjectNameUtil.withoutTransactionName((ObjectName)fixed1name);
        platformMBeanServer.getMBeanInfo(on);
        Assert.assertEquals((Object)5, (Object)platformMBeanServer.getAttribute(on, "ThreadCount"));
        Assert.assertFalse((boolean)TestingFixedThreadPool.allExecutors.get(0).isShutdown());
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.assertVersion(1, 2);
        ObjectName retrievedName = transaction.lookupConfigBean("fixed", fixed1);
        Assert.assertNotNull((Object)retrievedName);
        TestingFixedThreadPoolConfigMXBean fixedConfigProxy = (TestingFixedThreadPoolConfigMXBean)transaction.newMXBeanProxy(retrievedName, TestingFixedThreadPoolConfigMXBean.class);
        Assert.assertEquals((long)5L, (long)fixedConfigProxy.getThreadCount());
        transaction.destroyModule(ObjectNameUtil.createTransactionModuleON((String)transaction.getTransactionName(), (String)"fixed", (String)fixed1));
        transaction.commit();
        Assert.assertEquals((long)2L, (long)this.configRegistryClient.getVersion());
        Assert.assertEquals((long)0L, (long)TestingFixedThreadPool.allExecutors.size());
        try {
            platformMBeanServer.getMBeanInfo(on);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InstanceNotFoundException));
        }
    }

    @Test
    public void testReplaceFixed1() throws Exception {
        this.firstCommit();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.destroyModule(ObjectNameUtil.createTransactionModuleON((String)transaction.getTransactionName(), (String)"fixed", (String)fixed1));
        ObjectName fixed1name = transaction.createModule("fixed", fixed1);
        TestingFixedThreadPoolConfigMXBean fixedConfigProxy = (TestingFixedThreadPoolConfigMXBean)transaction.newMXBeanProxy(fixed1name, TestingFixedThreadPoolConfigMXBean.class);
        fixedConfigProxy.setThreadCount(10);
        transaction.commit();
        this.checkThreadPools(1, 10);
    }

    private void checkThreadPools(int expectedTotalNumberOfExecutors, int expectedNumberOfThreadsInLastExecutor) {
        Assert.assertEquals((long)expectedTotalNumberOfExecutors, (long)TestingFixedThreadPool.allExecutors.size());
        for (int i = 0; i < expectedTotalNumberOfExecutors - 1; ++i) {
            Assert.assertTrue((boolean)TestingFixedThreadPool.allExecutors.get(i).isShutdown());
        }
        ThreadPoolExecutor lastExecutor = TestingFixedThreadPool.allExecutors.get(expectedTotalNumberOfExecutors - 1);
        Assert.assertFalse((boolean)lastExecutor.isShutdown());
        Assert.assertEquals((long)expectedNumberOfThreadsInLastExecutor, (long)lastExecutor.getMaximumPoolSize());
    }

    @Test
    public void testTriggerRecreatingInstance() throws Exception {
        this.firstCommit();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        TestingFixedThreadPoolConfigMXBean fixedConfigProxy = this.startReconfiguringFixed1ThreadPool(transaction);
        fixedConfigProxy.setTriggerNewInstanceCreation(true);
        CommitStatus commitStatus = transaction.commit();
        this.checkThreadPools(1, 5);
        CommitStatus expected = new CommitStatus(emptyONs, emptyONs, fixed1List);
        Assert.assertEquals((Object)expected, (Object)commitStatus);
    }

    private TestingFixedThreadPoolConfigMXBean startReconfiguringFixed1ThreadPool(ConfigTransactionJMXClient transaction) throws InstanceNotFoundException {
        ObjectName fixed1name = transaction.lookupConfigBean("fixed", fixed1);
        TestingFixedThreadPoolConfigMXBean fixedConfigProxy = (TestingFixedThreadPoolConfigMXBean)transaction.newMXBeanProxy(fixed1name, TestingFixedThreadPoolConfigMXBean.class);
        return fixedConfigProxy;
    }

    @Test
    public void testAbort() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        Assert.assertEquals((long)1L, (long)this.configRegistryClient.getOpenConfigs().size());
        transaction.abortConfig();
        Assert.assertEquals((long)0L, (long)this.configRegistryClient.getOpenConfigs().size());
        try {
            platformMBeanServer.getMBeanInfo(transaction.getObjectName());
            Assert.fail();
        }
        catch (InstanceNotFoundException e) {
            Assert.assertEquals((Object)"org.opendaylight.controller:TransactionName=ConfigTransaction-0-1,type=ConfigTransaction", (Object)e.getMessage());
        }
    }

    @Test
    public void testOptimisticLock_ConfigTransactionClient() throws Exception {
        ConfigTransactionJMXClient transaction1 = this.configRegistryClient.createTransaction();
        ConfigTransactionJMXClient transaction2 = this.configRegistryClient.createTransaction();
        transaction2.assertVersion(0, 2);
        transaction2.commit();
        try {
            transaction1.commit();
            Assert.fail();
        }
        catch (ConflictingVersionException e) {
            Assert.assertEquals((Object)"Optimistic lock failed. Expected parent version 2, was 0", (Object)e.getMessage());
        }
    }

    @Test
    public void testOptimisticLock_ConfigRegistry() throws Exception {
        ConfigTransactionJMXClient transaction1 = this.configRegistryClient.createTransaction();
        ConfigTransactionJMXClient transaction2 = this.configRegistryClient.createTransaction();
        transaction2.assertVersion(0, 2);
        transaction2.commit();
        try {
            this.configRegistryClient.commitConfig(transaction1.getObjectName());
            Assert.fail();
        }
        catch (ConflictingVersionException e) {
            Assert.assertEquals((Object)"Optimistic lock failed. Expected parent version 2, was 0", (Object)e.getMessage());
        }
    }

    @Test
    public void testQNames() {
        Set availableModuleFactoryQNames = this.configRegistryClient.getAvailableModuleFactoryQNames();
        String expected = "(namespace?revision=2012-12-12)name";
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{expected}), (Object)availableModuleFactoryQNames);
    }
}

