/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.factoriesresolver;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;

public class HardcodedModuleFactoriesResolver
implements ModuleFactoriesResolver {
    private final Map<String, Map.Entry<ModuleFactory, BundleContext>> factories;

    public HardcodedModuleFactoriesResolver(BundleContext bundleContext, ModuleFactory ... list) {
        this.factories = new HashMap<String, Map.Entry<ModuleFactory, BundleContext>>(list.length);
        for (ModuleFactory moduleFactory : list) {
            String moduleName = moduleFactory.getImplementationName();
            if (moduleName == null || moduleName.isEmpty()) {
                throw new IllegalStateException("Invalid implementation name for " + moduleFactory);
            }
            Map.Entry<ModuleFactory, BundleContext> conflicting = this.factories.get(moduleName);
            if (conflicting != null) {
                throw new IllegalArgumentException(String.format("Module name is not unique. Found two conflicting factories with same name '%s':\n\t%s\n\t%s\n", moduleName, conflicting.getKey(), moduleFactory));
            }
            this.factories.put(moduleName, new AbstractMap.SimpleEntry<ModuleFactory, BundleContext>(moduleFactory, bundleContext));
        }
    }

    public Map<String, Map.Entry<ModuleFactory, BundleContext>> getAllFactories() {
        return this.factories;
    }
}

