/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import com.google.common.collect.Lists;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.config.manager.impl.osgi.BundleContextBackedModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BundleContextBackedModuleFactoriesResolverTest {
    @Mock
    private BundleContext bundleContext;
    private BundleContextBackedModuleFactoriesResolver resolver;
    private ServiceReference<?> s1;
    private ServiceReference<?> s2;
    private ModuleFactory f1;
    private ModuleFactory f2;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.s1 = this.getServiceRef();
        this.s2 = this.getServiceRef();
        ((BundleContext)Mockito.doReturn((Object)Lists.newArrayList((Object[])new ServiceReference[]{this.s1, this.s2})).when((Object)this.bundleContext)).getServiceReferences(ModuleFactory.class, null);
        this.f1 = BundleContextBackedModuleFactoriesResolverTest.getMockFactory("f1");
        ((BundleContext)Mockito.doReturn((Object)this.f1).when((Object)this.bundleContext)).getService(this.s1);
        this.f2 = BundleContextBackedModuleFactoriesResolverTest.getMockFactory("f2");
        ((BundleContext)Mockito.doReturn((Object)this.f2).when((Object)this.bundleContext)).getService(this.s2);
        this.resolver = new BundleContextBackedModuleFactoriesResolver(this.bundleContext);
    }

    private static ModuleFactory getMockFactory(String name) {
        ModuleFactory mock = (ModuleFactory)Mockito.mock(ModuleFactory.class);
        ((ModuleFactory)Mockito.doReturn((Object)name).when((Object)mock)).toString();
        ((ModuleFactory)Mockito.doReturn((Object)name).when((Object)mock)).getImplementationName();
        return mock;
    }

    private ServiceReference<?> getServiceRef() {
        ServiceReference mock = (ServiceReference)Mockito.mock(ServiceReference.class);
        ((ServiceReference)Mockito.doReturn((Object)"serviceRef").when((Object)mock)).toString();
        Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
        ((Bundle)Mockito.doReturn((Object)this.bundleContext).when((Object)bundle)).getBundleContext();
        ((ServiceReference)Mockito.doReturn((Object)bundle).when((Object)mock)).getBundle();
        return mock;
    }

    @Test
    public void testGetAllFactories() throws Exception {
        Map allFactories = this.resolver.getAllFactories();
        Assert.assertEquals((long)2L, (long)allFactories.size());
        Assert.assertTrue((boolean)allFactories.containsKey(this.f1.getImplementationName()));
        Assert.assertEquals((Object)this.f1, ((Map.Entry)allFactories.get(this.f1.getImplementationName())).getKey());
        Assert.assertEquals((Object)this.bundleContext, ((Map.Entry)allFactories.get(this.f1.getImplementationName())).getValue());
        Assert.assertTrue((boolean)allFactories.containsKey(this.f2.getImplementationName()));
        Assert.assertEquals((Object)this.f2, ((Map.Entry)allFactories.get(this.f2.getImplementationName())).getKey());
        Assert.assertEquals((Object)this.bundleContext, ((Map.Entry)allFactories.get(this.f2.getImplementationName())).getValue());
    }

    @Test
    public void testDuplicateFactories() throws Exception {
        ((BundleContext)Mockito.doReturn((Object)this.f1).when((Object)this.bundleContext)).getService(this.s2);
        try {
            this.resolver.getAllFactories();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)this.f1.getImplementationName()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"unique"));
            return;
        }
        Assert.fail((String)"Should fail with duplicate factory name");
    }

    @Test(expected=NullPointerException.class)
    public void testNullFactory() throws Exception {
        ((BundleContext)Mockito.doReturn(null).when((Object)this.bundleContext)).getService(this.s2);
        this.resolver.getAllFactories();
    }

    @Test(expected=IllegalStateException.class)
    public void testNullFactoryName() throws Exception {
        ((ModuleFactory)Mockito.doReturn(null).when((Object)this.f1)).getImplementationName();
        this.resolver.getAllFactories();
    }

    @Test(expected=NullPointerException.class)
    public void testNullBundleName() throws Exception {
        ((ServiceReference)Mockito.doReturn(null).when(this.s1)).getBundle();
        this.resolver.getAllFactories();
    }
}

