/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import java.util.Dictionary;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.config.manager.impl.osgi.mapping.BindingContextProvider;
import org.opendaylight.controller.config.manager.impl.osgi.mapping.RefreshingSCPModuleInfoRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.api.ModuleInfoRegistry;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RefreshingSCPModuleInfoRegistryTest {
    @Mock
    SchemaSourceProvider<YangTextSchemaSource> sourceProvider;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testConstructor() throws Exception {
        ModuleInfoRegistry reg = (ModuleInfoRegistry)Mockito.mock(ModuleInfoRegistry.class);
        SchemaContextProvider prov = (SchemaContextProvider)Mockito.mock(SchemaContextProvider.class);
        ((SchemaContextProvider)Mockito.doReturn((Object)"string").when((Object)prov)).toString();
        BundleContext ctxt = (BundleContext)Mockito.mock(BundleContext.class);
        ServiceRegistration servReg = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
        ((BundleContext)Mockito.doReturn((Object)servReg).when((Object)ctxt)).registerService((Class)Matchers.any(Class.class), Matchers.any(SchemaContextProvider.class), (Dictionary)Matchers.any(Dictionary.class));
        ((BundleContext)Mockito.doReturn((Object)servReg).when((Object)ctxt)).registerService(Mockito.anyString(), Matchers.any(Object.class), (Dictionary)Matchers.any(Dictionary.class));
        ((ServiceRegistration)Mockito.doNothing().when((Object)servReg)).setProperties((Dictionary)Matchers.any(Dictionary.class));
        ClassLoadingStrategy classLoadingStrat = (ClassLoadingStrategy)Mockito.mock(ClassLoadingStrategy.class);
        BindingContextProvider codecRegistryProvider = (BindingContextProvider)Mockito.mock(BindingContextProvider.class);
        ((BindingContextProvider)Mockito.doNothing().when((Object)codecRegistryProvider)).update(classLoadingStrat, prov);
        BindingRuntimeContext bindingRuntimeContext = (BindingRuntimeContext)Mockito.mock(BindingRuntimeContext.class);
        ((BindingRuntimeContext)Mockito.doReturn((Object)"B-runtime-context").when((Object)bindingRuntimeContext)).toString();
        ((BindingContextProvider)Mockito.doReturn((Object)bindingRuntimeContext).when((Object)codecRegistryProvider)).getBindingContext();
        RefreshingSCPModuleInfoRegistry scpreg = new RefreshingSCPModuleInfoRegistry(reg, prov, classLoadingStrat, this.sourceProvider, codecRegistryProvider, ctxt);
        ((ServiceRegistration)Mockito.doNothing().when((Object)servReg)).unregister();
        YangModuleInfo modInfo = (YangModuleInfo)Mockito.mock(YangModuleInfo.class);
        ((YangModuleInfo)Mockito.doReturn((Object)"").when((Object)modInfo)).toString();
        ObjectRegistration ymi = (ObjectRegistration)Mockito.mock(ObjectRegistration.class);
        ((ModuleInfoRegistry)Mockito.doReturn((Object)ymi).when((Object)reg)).registerModuleInfo(modInfo);
        scpreg.registerModuleInfo(modInfo);
        scpreg.updateService();
        ((BindingContextProvider)Mockito.verify((Object)codecRegistryProvider)).update(classLoadingStrat, prov);
        scpreg.close();
        ((ServiceRegistration)Mockito.verify((Object)servReg, (VerificationMode)Mockito.times((int)1))).setProperties((Dictionary)Matchers.any(Dictionary.class));
        ((ServiceRegistration)Mockito.verify((Object)servReg, (VerificationMode)Mockito.times((int)1))).unregister();
    }
}

