/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.parallelapsp.test;

import java.util.Map;
import javax.management.ObjectName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.test.AbstractParallelAPSPTest;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPool;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModuleFactory;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class DependentWiringTest
extends AbstractParallelAPSPTest {
    private final String fixed1 = "fixed1";

    @Before
    public void setUp() {
        super.initConfigTransactionManagerImpl(new HardcodedModuleFactoriesResolver(this.mockedContext, new TestingFixedThreadPoolModuleFactory(), new TestingParallelAPSPModuleFactory()));
    }

    @After
    public void tearDown() {
        TestingFixedThreadPool.cleanUp();
    }

    @Override
    protected String getThreadPoolImplementationName() {
        return "fixed";
    }

    @Test
    public void testDependencies() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName threadPoolTransactionON = this.createFixed1(transaction, 10);
        ObjectName apspNameTransactionON = this.createParallelAPSP(transaction, threadPoolTransactionON);
        TestingParallelAPSPConfigMXBean parallelAPSPConfigProxy = (TestingParallelAPSPConfigMXBean)transaction.newMXBeanProxy(apspNameTransactionON, TestingParallelAPSPConfigMXBean.class);
        parallelAPSPConfigProxy.setSomeParam("");
        try {
            transaction.validateConfig();
            Assert.fail();
        }
        catch (ValidationException e) {
            for (Map.Entry exception : e.getFailedValidations().entrySet()) {
                for (Map.Entry entry : ((Map)exception.getValue()).entrySet()) {
                    Assert.assertThat((Object)((ValidationException.ExceptionMessageWithStackTrace)entry.getValue()).getMessage(), (Matcher)CoreMatchers.containsString((String)"Parameter 'SomeParam' is blank"));
                }
            }
        }
        try {
            transaction.commit();
            Assert.fail();
        }
        catch (ValidationException e) {
            for (Map.Entry exception : e.getFailedValidations().entrySet()) {
                for (Map.Entry entry : ((Map)exception.getValue()).entrySet()) {
                    String err = ((ValidationException.ExceptionMessageWithStackTrace)entry.getValue()).getMessage();
                    Assert.assertTrue((String)("Unexpected error message: " + err), (boolean)err.contains("Parameter 'SomeParam' is blank"));
                }
            }
        }
        parallelAPSPConfigProxy.setSomeParam("abc");
        transaction.commit();
        ObjectName apspON = ObjectNameUtil.withoutTransactionName((ObjectName)apspNameTransactionON);
        TestingParallelAPSPConfigMXBean parallelAPSPRuntimeProxy = (TestingParallelAPSPConfigMXBean)this.configRegistryClient.newMXBeanProxy(apspON, TestingParallelAPSPConfigMXBean.class);
        Assert.assertEquals((Object)10, (Object)parallelAPSPRuntimeProxy.getMaxNumberOfThreads());
        int newNumberOfThreads = 20;
        ConfigTransactionJMXClient transaction2 = this.configRegistryClient.createTransaction();
        ObjectName threadPoolNamesNewTx = transaction2.lookupConfigBean(this.getThreadPoolImplementationName(), "fixed1");
        TestingFixedThreadPoolConfigMXBean fixedConfigTransactionProxy = (TestingFixedThreadPoolConfigMXBean)transaction2.newMXBeanProxy(threadPoolNamesNewTx, TestingFixedThreadPoolConfigMXBean.class);
        fixedConfigTransactionProxy.setThreadCount(newNumberOfThreads);
        transaction2.commit();
        Assert.assertEquals((Object)newNumberOfThreads, (Object)parallelAPSPRuntimeProxy.getMaxNumberOfThreads());
    }

    @Test
    public void testUsingServiceReferences() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName threadPoolON = this.createFixed1(transaction, 10);
        transaction.lookupConfigBean(this.getThreadPoolImplementationName(), "fixed1");
        String refName = "ref";
        ObjectName serviceReferenceON = transaction.saveServiceReference("(ns?revision=foo)testing-threadpool", refName, threadPoolON);
        this.createParallelAPSP(transaction, serviceReferenceON);
        transaction.commit();
    }
}

