/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.parallelapsp.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.management.ObjectName;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.manager.impl.ClassBasedModuleFactory;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.test.AbstractParallelAPSPTest;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.TestingThreadPoolServiceInterface;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolIfc;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class MockedDependenciesTest
extends AbstractParallelAPSPTest {
    private final String threadPoolImplementationName = "mockedthreadpool";

    @Before
    public void setUp() {
        ClassBasedModuleFactory mockedThreadPoolConfigFactory = new ClassBasedModuleFactory("mockedthreadpool", MockedThreadPoolModule.class);
        super.initConfigTransactionManagerImpl(new HardcodedModuleFactoriesResolver(this.mockedContext, new TestingParallelAPSPModuleFactory(), mockedThreadPoolConfigFactory));
    }

    @Override
    protected String getThreadPoolImplementationName() {
        return "mockedthreadpool";
    }

    @Test
    public void testDependencies() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName threadPoolTransactionON = this.createFixed1(transaction, 10);
        this.createParallelAPSP(transaction, threadPoolTransactionON);
        transaction.commit();
    }

    public static class MockedThreadPool
    implements TestingThreadPoolIfc,
    Closeable {
        private final int threadCount;

        public MockedThreadPool(int threadCount) {
            this.threadCount = threadCount;
        }

        @Override
        public Executor getExecutor() {
            return null;
        }

        @Override
        public int getMaxNumberOfThreads() {
            return this.threadCount;
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class MockedThreadPoolModule
    implements Module,
    MockedTestingThreadPoolConfigMXBean,
    TestingThreadPoolServiceInterface {
        private final ModuleIdentifier moduleIdentifier;
        int threadCount;

        public MockedThreadPoolModule(DynamicMBeanWithInstance dynamicMBeanWithInstance, ModuleIdentifier moduleIdentifier) {
            this.moduleIdentifier = moduleIdentifier;
        }

        @Override
        public int getThreadCount() {
            return this.threadCount;
        }

        @Override
        public void setThreadCount(int threadCount) {
            this.threadCount = threadCount;
        }

        public void validate() {
        }

        public boolean canReuse(Module oldModule) {
            return false;
        }

        public Closeable getInstance() {
            return new MockedThreadPool(this.threadCount);
        }

        public ModuleIdentifier getIdentifier() {
            return this.moduleIdentifier;
        }
    }

    public static interface MockedTestingThreadPoolConfigMXBean
    extends TestingThreadPoolConfigMXBean {
        public void setThreadCount(int var1);
    }
}

