/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.opendaylight.controller.config.api.runtime.HierarchicalRuntimeBeanRegistration;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.api.runtime.RuntimeBean;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.TestingScheduledThreadPoolIfc;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.runtimebeans.TestingScheduledRuntimeBean;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolIfc;

public class TestingScheduledThreadPoolImpl
implements TestingThreadPoolIfc,
TestingScheduledThreadPoolIfc,
Closeable {
    private static volatile int numberOfCloseMethodCalls = 0;
    private final ScheduledThreadPoolExecutor executor;
    private final RootRuntimeBeanRegistrator runtimeBeanRegistrator;
    public static final List<ScheduledThreadPoolExecutor> ALLEXECUTORS = Lists.newLinkedList();

    public TestingScheduledThreadPoolImpl(RootRuntimeBeanRegistrator runtimeBeanRegistrator, int corePoolSize) {
        this.runtimeBeanRegistrator = runtimeBeanRegistrator;
        this.executor = new ScheduledThreadPoolExecutor(corePoolSize);
        ALLEXECUTORS.add(this.executor);
        HierarchicalRuntimeBeanRegistration hierarchicalRuntimeBeanRegistration = runtimeBeanRegistrator.registerRoot((RuntimeBean)new TestingScheduledRuntimeBean());
        hierarchicalRuntimeBeanRegistration.register("a", "b", (RuntimeBean)new TestingScheduledRuntimeBean());
    }

    @Override
    public void close() {
        ++numberOfCloseMethodCalls;
        this.runtimeBeanRegistrator.close();
        this.executor.shutdown();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return this.executor;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public int getMaxNumberOfThreads() {
        return this.executor.getCorePoolSize();
    }

    public static void cleanUp() {
        for (ScheduledThreadPoolExecutor executor : ALLEXECUTORS) {
            executor.shutdown();
        }
        ALLEXECUTORS.clear();
        numberOfCloseMethodCalls = 0;
    }

    public static int getNumberOfCloseMethodCalls() {
        return numberOfCloseMethodCalls;
    }
}

