/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.TestingScheduledThreadPoolConfigBeanMXBean;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.test.AbstractScheduledTest;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class RuntimeBeanTest
extends AbstractScheduledTest {
    ObjectName ifc1runtimeON1 = ObjectNameUtil.createRuntimeBeanName((String)"scheduled", (String)"scheduled1", (Map)Maps.newHashMap());
    ObjectName ifc1runtimeON2 = ObjectNameUtil.createRuntimeBeanName((String)"scheduled", (String)"scheduled1", (Map)ImmutableMap.of((Object)"a", (Object)"b"));
    List<ObjectName> allObjectNames = Lists.newArrayList((Object[])new ObjectName[]{this.ifc1runtimeON1, this.ifc1runtimeON2});

    private ObjectName createScheduled() throws InstanceAlreadyExistsException, ConflictingVersionException, ValidationException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName createdConfigBean = transaction.createModule("scheduled", "scheduled1");
        transaction.commit();
        return createdConfigBean;
    }

    @Test
    public void testCreateScheduled() throws Exception {
        this.createScheduled();
        this.checkRuntimeBeans();
    }

    private void checkRuntimeBeans() throws Exception {
        for (ObjectName on : this.allObjectNames) {
            RuntimeBeanTest.checkRuntimeBean(on);
        }
    }

    private static void checkRuntimeBean(ObjectName on) throws Exception {
        Assert.assertEquals((Object)0, (Object)platformMBeanServer.getAttribute(on, "ActualNumberOfThreads"));
    }

    private static void checkRuntimeBeanDoesNotExist(ObjectName on) throws Exception {
        try {
            RuntimeBeanTest.checkRuntimeBean(on);
            Assert.fail();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testLookup() throws Exception {
        this.createScheduled();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{this.ifc1runtimeON1, this.ifc1runtimeON2}), (Object)this.configRegistryClient.lookupRuntimeBeans());
    }

    @Test
    public void testReuse() throws Exception {
        ObjectName createdConfigBean = this.createScheduled();
        CommitStatus commitInfo = this.configRegistryClient.createTransaction().commit();
        ObjectName readableConfigBean = ObjectNameUtil.withoutTransactionName((ObjectName)createdConfigBean);
        List newInstances = Collections.emptyList();
        ArrayList reusedInstances = Lists.newArrayList((Object[])new ObjectName[]{readableConfigBean});
        List recreatedInstaces = Collections.emptyList();
        Assert.assertEquals((Object)new CommitStatus(newInstances, (List)reusedInstances, recreatedInstaces), (Object)commitInfo);
        this.checkRuntimeBeans();
    }

    @Test
    public void testRecreate() throws Exception {
        ObjectName createdConfigBean = this.createScheduled();
        ConfigTransactionJMXClient configTransaction = this.configRegistryClient.createTransaction();
        ObjectName scheduledWritableON = configTransaction.lookupConfigBean("scheduled", "scheduled1");
        TestingScheduledThreadPoolConfigBeanMXBean scheduledWritableProxy = (TestingScheduledThreadPoolConfigBeanMXBean)configTransaction.newMXBeanProxy(scheduledWritableON, TestingScheduledThreadPoolConfigBeanMXBean.class);
        scheduledWritableProxy.setRecreate(true);
        CommitStatus commitInfo = configTransaction.commit();
        ObjectName readableConfigBean = ObjectNameUtil.withoutTransactionName((ObjectName)createdConfigBean);
        List newInstances = Collections.emptyList();
        List reusedInstances = Collections.emptyList();
        ArrayList recreatedInstaces = Lists.newArrayList((Object[])new ObjectName[]{readableConfigBean});
        Assert.assertEquals((Object)new CommitStatus(newInstances, reusedInstances, (List)recreatedInstaces), (Object)commitInfo);
        this.checkRuntimeBeans();
    }

    @Test
    public void testDestroy_shouldUnregisterRuntimeBeans() throws Exception {
        ObjectName createdConfigBean = this.createScheduled();
        ConfigTransactionJMXClient configTransaction = this.configRegistryClient.createTransaction();
        configTransaction.destroyModule(ObjectNameUtil.createTransactionModuleON((String)configTransaction.getTransactionName(), (ObjectName)createdConfigBean));
        configTransaction.commit();
        for (ObjectName on : this.allObjectNames) {
            RuntimeBeanTest.checkRuntimeBeanDoesNotExist(on);
        }
    }
}

