/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.test;

import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.TestingScheduledThreadPoolImpl;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.test.AbstractScheduledTest;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class TwoInterfacesExportTest
extends AbstractScheduledTest {
    private void assertExists(String moduleName, String instanceName) throws Exception {
        this.assertExists(null, moduleName, instanceName);
    }

    private void assertExists(@Nullable ConfigTransactionJMXClient transaction, String moduleName, String instanceName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (transaction != null) {
            transaction.lookupConfigBean(moduleName, instanceName);
            platformMBeanServer.getMBeanInfo(ObjectNameUtil.createTransactionModuleON((String)transaction.getTransactionName(), (String)moduleName, (String)instanceName));
        } else {
            this.configRegistryClient.lookupConfigBean(moduleName, instanceName);
            platformMBeanServer.getMBeanInfo(ObjectNameUtil.createReadOnlyModuleON((String)moduleName, (String)instanceName));
        }
    }

    private void assertNotExists(String moduleName, String instanceName) {
        this.assertNotExists(null, moduleName, instanceName);
    }

    private void assertNotExists(@Nullable ConfigTransactionJMXClient transaction, String moduleName, String instanceName) {
        if (transaction != null) {
            try {
                transaction.lookupConfigBean(moduleName, instanceName);
                Assert.fail();
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        } else {
            try {
                this.configRegistryClient.lookupConfigBean(moduleName, instanceName);
                Assert.fail();
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void twoInterfaceNamesAfterCreatingConfigBean() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName scheduled1name = transaction.createModule("scheduled", "scheduled1");
        ObjectName retrievedName = transaction.lookupConfigBean("scheduled", "scheduled1");
        Assert.assertEquals((Object)scheduled1name, (Object)retrievedName);
        String moduleName = "scheduled";
        retrievedName = transaction.lookupConfigBean(moduleName, "scheduled1");
        ObjectName expected = ObjectNameUtil.createTransactionModuleON((String)transaction.getTransactionName(), (String)moduleName, (String)"scheduled1");
        Assert.assertEquals((Object)expected, (Object)retrievedName);
        transaction.commit();
        Assert.assertEquals((long)1L, (long)TestingScheduledThreadPoolImpl.ALLEXECUTORS.size());
        Assert.assertFalse((boolean)TestingScheduledThreadPoolImpl.ALLEXECUTORS.get(0).isTerminated());
        Assert.assertEquals((long)0L, (long)TestingScheduledThreadPoolImpl.getNumberOfCloseMethodCalls());
        this.assertExists(moduleName, "scheduled1");
        transaction = this.configRegistryClient.createTransaction();
        transaction.destroyModule(ObjectNameUtil.createTransactionModuleON((String)transaction.getTransactionName(), (String)moduleName, (String)"scheduled1"));
        transaction.commit();
        Assert.assertEquals((long)1L, (long)TestingScheduledThreadPoolImpl.ALLEXECUTORS.size());
        Assert.assertTrue((boolean)TestingScheduledThreadPoolImpl.ALLEXECUTORS.get(0).isTerminated());
        Assert.assertEquals((long)1L, (long)TestingScheduledThreadPoolImpl.getNumberOfCloseMethodCalls());
        this.assertNotExists(moduleName, "scheduled1");
        transaction = this.configRegistryClient.createTransaction();
        this.assertNotExists(transaction, moduleName, "scheduled1");
    }

    @Test
    public void tryToRegisterThreadPoolWithSameName() throws InstanceAlreadyExistsException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.createModule("scheduled", "scheduled1");
        try {
            transaction.createModule("scheduled", "scheduled1");
            Assert.fail();
        }
        catch (InstanceAlreadyExistsException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is an instance registered with name ModuleIdentifier{factoryName='scheduled', instanceName='scheduled1'}"));
        }
    }

    @Test
    public void testRegisteringAllIfcNames() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.createModule("scheduled", "scheduled1");
        transaction.commit();
        this.assertExists("scheduled", "scheduled1");
        transaction = this.configRegistryClient.createTransaction();
        this.assertExists(transaction, "scheduled", "scheduled1");
    }

    @Test
    public void testWithAPSP_useScheduledNames() throws InstanceAlreadyExistsException, ValidationException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        ObjectName scheduledName = transaction.createModule("scheduled", "scheduled1");
        ObjectName apspName = transaction.createModule("parallel", "apsp1");
        TestingParallelAPSPConfigMXBean apspProxy = (TestingParallelAPSPConfigMXBean)transaction.newMXBeanProxy(apspName, TestingParallelAPSPConfigMXBean.class);
        apspProxy.setThreadPool(scheduledName);
        apspProxy.setSomeParam("someParam");
        transaction.validateConfig();
    }

    @Test
    public void testWithAPSP_useIfcNameMismatch() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.createModule("scheduled", "scheduled1");
        ObjectName apspName = transaction.createModule("parallel", "apsp1");
        TestingParallelAPSPConfigMXBean apspProxy = (TestingParallelAPSPConfigMXBean)transaction.newMXBeanProxy(apspName, TestingParallelAPSPConfigMXBean.class);
        apspProxy.setThreadPool(ObjectNameUtil.createReadOnlyModuleON((String)"scheduled", (String)"scheduled1"));
        apspProxy.setSomeParam("someParam");
        transaction.validateConfig();
        transaction.commit();
    }
}

