/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.threadpool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingModifiableThreadPoolIfc;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolIfc;

public class TestingFixedThreadPool
implements TestingThreadPoolIfc,
Closeable,
TestingModifiableThreadPoolIfc {
    private final ThreadPoolExecutor executorService;
    private final String uniqueName;
    public static final List<ThreadPoolExecutor> ALL_EXECUTORS = Collections.synchronizedList(Lists.newLinkedList());

    public static void cleanUp() {
        for (ExecutorService executorService : ALL_EXECUTORS) {
            executorService.shutdown();
        }
        ALL_EXECUTORS.clear();
    }

    public TestingFixedThreadPool(int threadCount, String uniqueName) {
        Preconditions.checkNotNull((Object)uniqueName);
        this.uniqueName = uniqueName;
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadCount);
        ALL_EXECUTORS.add(this.executorService);
    }

    @Override
    public Executor getExecutor() {
        return this.executorService;
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
        ALL_EXECUTORS.remove(this.executorService);
    }

    @Override
    public int getMaxNumberOfThreads() {
        return this.executorService.getMaximumPoolSize();
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public void setMaximumNumberOfThreads(int activeCount) {
        Preconditions.checkArgument((activeCount > 0 ? 1 : 0) != 0);
        this.executorService.setMaximumPoolSize(activeCount);
    }
}

