/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.threadpool;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.ModifiableThreadPoolServiceInterface;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPool;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolConfigMXBean;
import org.opendaylight.controller.config.spi.Module;

@NotThreadSafe
public class TestingFixedThreadPoolModule
implements TestingFixedThreadPoolConfigMXBean,
Module,
TestingThreadPoolConfigMXBean,
ModifiableThreadPoolServiceInterface {
    private final AutoCloseable oldCloseable;
    private final TestingFixedThreadPool oldInstance;
    private final ModuleIdentifier name;
    private TestingFixedThreadPool instance;
    private int threadCount = 0;
    private boolean triggerNewInstanceCreation;

    TestingFixedThreadPoolModule(ModuleIdentifier name, @Nullable AutoCloseable oldCloseable, @Nullable TestingFixedThreadPool oldInstance) {
        this.name = name;
        this.oldCloseable = oldCloseable;
        this.oldInstance = oldInstance;
    }

    @Override
    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public boolean isTriggerNewInstanceCreation() {
        return this.triggerNewInstanceCreation;
    }

    @Override
    public void setTriggerNewInstanceCreation(boolean triggerNewInstanceCreation) {
        this.triggerNewInstanceCreation = triggerNewInstanceCreation;
    }

    private boolean isReusable() {
        return this.oldInstance != null;
    }

    public void validate() {
        Preconditions.checkState((this.threadCount > 0 ? 1 : 0) != 0, (Object)"Parameter 'threadCount' must be greater than 0");
    }

    public boolean canReuse(Module oldModule) {
        return this.isReusable() && !this.triggerNewInstanceCreation;
    }

    public Closeable getInstance() {
        if (this.instance == null) {
            if (this.isReusable() && !this.triggerNewInstanceCreation) {
                this.oldInstance.setMaximumNumberOfThreads(this.threadCount);
                this.instance = this.oldInstance;
            } else {
                if (this.oldCloseable != null) {
                    try {
                        this.oldCloseable.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.instance = new TestingFixedThreadPool(this.threadCount, this.name.toString());
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.name;
    }
}

