/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager;

import java.lang.management.ManagementFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImpl;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModuleFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRegistryImplTest
extends AbstractLockedPlatformMBeanServerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigRegistryImplTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailOnTwoFactoriesExportingSameImpl() {
        TestingFixedThreadPoolModuleFactory factory = new TestingFixedThreadPoolModuleFactory();
        BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
        ConfigRegistryImpl configRegistry = null;
        try {
            HardcodedModuleFactoriesResolver resolver = new HardcodedModuleFactoriesResolver((BundleContext)Mockito.mock(BundleContext.class), factory, factory);
            configRegistry = new ConfigRegistryImpl((ModuleFactoriesResolver)resolver, ManagementFactory.getPlatformMBeanServer(), null);
            configRegistry.beginConfig();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("Module name is not unique. Found two conflicting factories with same name 'fixed':"));
            Mockito.verifyZeroInteractions((Object[])new Object[]{context});
        }
        finally {
            try {
                configRegistry.close();
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception", (Throwable)e);
            }
        }
    }
}

