/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.ClassBasedModuleFactory;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImpl;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImplMXBean;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.ConfigRegistryJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.JMXNotifierConfigRegistry;
import org.opendaylight.controller.config.manager.impl.osgi.mapping.BindingContextProvider;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.TestingScheduledThreadPoolImpl;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPool;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractConfigTest
extends AbstractLockedPlatformMBeanServerTest {
    protected ConfigRegistryJMXRegistrator configRegistryJMXRegistrator;
    protected ConfigRegistryImpl configRegistry;
    private JMXNotifierConfigRegistry notifyingConfigRegistry;
    protected ConfigRegistryJMXClient configRegistryClient;
    protected BaseJMXRegistrator baseJmxRegistrator;
    @Mock
    protected BundleContext mockedContext;
    @Mock
    protected ServiceRegistration<?> mockedServiceRegistration;
    protected BundleContextServiceRegistrationHandler currentBundleContextServiceRegistrationHandler;

    @Before
    public void setUpMocks() {
        MockitoAnnotations.initMocks((Object)this);
    }

    protected BundleContextServiceRegistrationHandler getBundleContextServiceRegistrationHandler(Class<?> serviceType) {
        return this.currentBundleContextServiceRegistrationHandler;
    }

    protected void initConfigTransactionManagerImpl(ModuleFactoriesResolver resolver) {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.configRegistryJMXRegistrator = new ConfigRegistryJMXRegistrator(platformMBeanServer);
        this.initBundleContext();
        this.baseJmxRegistrator = new BaseJMXRegistrator(platformMBeanServer);
        this.configRegistry = new ConfigRegistryImpl(resolver, platformMBeanServer, this.baseJmxRegistrator, new BindingContextProvider(){

            public synchronized void update(ClassLoadingStrategy classLoadingStrategy, SchemaContextProvider ctxProvider) {
            }

            public synchronized BindingRuntimeContext getBindingContext() {
                return AbstractConfigTest.this.getBindingRuntimeContext();
            }
        });
        this.notifyingConfigRegistry = new JMXNotifierConfigRegistry((ConfigRegistryImplMXBean)this.configRegistry, platformMBeanServer);
        try {
            this.configRegistryJMXRegistrator.registerToJMXNoNotifications((ConfigRegistryImplMXBean)this.configRegistry);
            this.configRegistryJMXRegistrator.registerToJMX((ConfigRegistryImplMXBean)this.notifyingConfigRegistry);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        this.configRegistryClient = new ConfigRegistryJMXClient(platformMBeanServer);
        this.currentBundleContextServiceRegistrationHandler = new RecordingBundleContextServiceRegistrationHandler();
    }

    private void initBundleContext() {
        ((ServiceRegistration)Mockito.doNothing().when(this.mockedServiceRegistration)).unregister();
        RegisterServiceAnswer answer = new RegisterServiceAnswer();
        ((BundleContext)Mockito.doAnswer((Answer)answer).when((Object)this.mockedContext)).registerService((String)Matchers.any(), Matchers.any(), (Dictionary)Matchers.any());
        ((BundleContext)Mockito.doAnswer((Answer)answer).when((Object)this.mockedContext)).registerService((Class)Matchers.any(), Matchers.any(), (Dictionary)Matchers.any());
    }

    @After
    public final void cleanUpConfigTransactionManagerImpl() {
        this.configRegistryJMXRegistrator.close();
        this.notifyingConfigRegistry.close();
        this.configRegistry.close();
        TestingFixedThreadPool.cleanUp();
        TestingScheduledThreadPoolImpl.cleanUp();
    }

    protected void destroyAllConfigBeans() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        Set all = transaction.lookupConfigBeans();
        while (all.size() > 0) {
            transaction.destroyModule((ObjectName)all.iterator().next());
            all = transaction.lookupConfigBeans();
        }
        transaction.commit();
    }

    protected void assertStatus(CommitStatus status, int expectedNewInstances, int expectedRecreatedInstances, int expectedReusedInstances) {
        Assert.assertEquals((String)("New instances mismatch in " + status), (long)expectedNewInstances, (long)status.getNewInstances().size());
        Assert.assertEquals((String)("Recreated instances mismatch in " + status), (long)expectedRecreatedInstances, (long)status.getRecreatedInstances().size());
        Assert.assertEquals((String)("Reused instances mismatch in " + status), (long)expectedReusedInstances, (long)status.getReusedInstances().size());
    }

    protected void assertBeanCount(int index, String configMXBeanName) {
        Assert.assertEquals((long)index, (long)this.configRegistry.lookupConfigBeans(configMXBeanName).size());
    }

    protected ClassBasedModuleFactory createClassBasedCBF(Class<? extends Module> configBeanClass, String implementationName) {
        return new ClassBasedModuleFactory(implementationName, configBeanClass);
    }

    protected BindingRuntimeContext getBindingRuntimeContext() {
        return (BindingRuntimeContext)Mockito.mock(BindingRuntimeContext.class);
    }

    protected <T> T rethrowCause(T innerObject) {
        Object proxy = Proxy.newProxyInstance(innerObject.getClass().getClassLoader(), innerObject.getClass().getInterfaces(), (proxy1, method, args) -> {
            try {
                return method.invoke(innerObject, args);
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getTargetException();
                }
                catch (RuntimeMBeanException e2) {
                    throw e2.getTargetException();
                }
            }
        });
        return (T)proxy;
    }

    protected void cleanDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalStateException("dir must be a directory");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.cleanDirectory(dir);
            }
            file.delete();
        }
    }

    private class RegisterServiceAnswer
    implements Answer<ServiceRegistration<?>> {
        private RegisterServiceAnswer() {
        }

        public ServiceRegistration<?> answer(InvocationOnMock invocation) throws Throwable {
            Object[] args = invocation.getArguments();
            Preconditions.checkArgument((args.length == 3 ? 1 : 0) != 0, (String)"Unexpected arguments size (expected 3 was %s)", (int)args.length);
            Object serviceTypeRaw = args[0];
            Object serviceInstance = args[1];
            Dictionary props = (Dictionary)args[2];
            if (serviceTypeRaw instanceof Class) {
                Class serviceType = (Class)serviceTypeRaw;
                this.invokeServiceHandler(serviceInstance, serviceType, props);
            } else if (serviceTypeRaw instanceof String[]) {
                for (String className : (String[])serviceTypeRaw) {
                    this.invokeServiceHandler(serviceInstance, className, props);
                }
            } else if (serviceTypeRaw instanceof String) {
                this.invokeServiceHandler(serviceInstance, (String)serviceTypeRaw, props);
            } else {
                throw new IllegalStateException("Not handling service registration of type, Unknown type" + serviceTypeRaw);
            }
            return AbstractConfigTest.this.mockedServiceRegistration;
        }

        public void invokeServiceHandler(Object serviceInstance, String className, Dictionary<String, ?> props) {
            try {
                Class<?> serviceType = Class.forName(className);
                this.invokeServiceHandler(serviceInstance, serviceType, props);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Not handling service registration of type " + className, e);
            }
        }

        private void invokeServiceHandler(Object serviceInstance, Class<?> serviceType, Dictionary<String, ?> props) {
            BundleContextServiceRegistrationHandler serviceRegistrationHandler = AbstractConfigTest.this.getBundleContextServiceRegistrationHandler(serviceType);
            if (serviceRegistrationHandler != null) {
                serviceRegistrationHandler.handleServiceRegistration(serviceType, serviceInstance, props);
            }
        }
    }

    public static interface BundleContextServiceRegistrationHandler {
        public void handleServiceRegistration(Class<?> var1, Object var2, Dictionary<String, ?> var3);
    }

    protected static class RecordingBundleContextServiceRegistrationHandler
    implements BundleContextServiceRegistrationHandler {
        private final List<RegistrationHolder> registrations = new LinkedList<RegistrationHolder>();

        protected RecordingBundleContextServiceRegistrationHandler() {
        }

        @Override
        public void handleServiceRegistration(Class<?> clazz, Object serviceInstance, Dictionary<String, ?> props) {
            this.registrations.add(new RegistrationHolder(clazz, serviceInstance, props));
        }

        public List<RegistrationHolder> getRegistrations() {
            return this.registrations;
        }

        protected static class RegistrationHolder {
            protected final Class<?> clazz;
            protected final Object instance;
            protected final Dictionary<String, ?> props;

            public RegistrationHolder(Class<?> clazz, Object instance, Dictionary<String, ?> props) {
                this.clazz = clazz;
                this.instance = instance;
                this.props = props;
            }
        }
    }
}

