/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.runtime.RuntimeBean;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImpl;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.RootRuntimeBeanRegistratorImpl;
import org.opendaylight.controller.config.manager.impl.runtimembean.TestingRuntimeBean;

public class ConfigRegistryImplLookupTest
extends AbstractLockedPlatformMBeanServerTest {
    private ConfigRegistryImpl configRegistryImpl;
    private BaseJMXRegistrator baseJMXRegistrator;
    private static final String MODULE_NAMEA = "moduleA";
    private static final String MODULE_NAMEB = "moduleB";
    private static final String INSTANCE_NAMEA = "instA";
    private static final String INSTANCE_NAMEB = "instB";
    private static final String INSTANCE_NAMEC = "instC";
    private static final ObjectName NAME1 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleA", (String)"instA");
    private static final ObjectName NAME2 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleA", (String)"instB");
    private static final ObjectName NAME3 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleA", (String)"instC");
    private static final ObjectName NAME4 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleB", (String)"instA");
    private static final ObjectName NAME5 = ObjectNameUtil.createRuntimeBeanName((String)"moduleA", (String)"instA", Collections.emptyMap());
    private static final ObjectName NAME6 = ObjectNameUtil.createRuntimeBeanName((String)"moduleA", (String)"instB", Collections.emptyMap());
    private static final ObjectName NAME8 = ObjectNameUtil.createRuntimeBeanName((String)"moduleB", (String)"instA", Collections.emptyMap());
    private static final ObjectName NAME9 = ObjectNameUtil.createTransactionModuleON((String)"transaction", (String)"moduleA", (String)"instA");

    @Before
    public void setUp() throws Exception {
        this.configRegistryImpl = new ConfigRegistryImpl(null, ManagementFactory.getPlatformMBeanServer(), null);
        Field field = this.configRegistryImpl.getClass().getDeclaredField("baseJMXRegistrator");
        field.setAccessible(true);
        this.baseJMXRegistrator = (BaseJMXRegistrator)field.get(this.configRegistryImpl);
        ConfigRegistryImplLookupTest.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, NAME1);
        ConfigRegistryImplLookupTest.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, NAME2);
        ConfigRegistryImplLookupTest.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, NAME3);
        ConfigRegistryImplLookupTest.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, NAME4);
        ConfigRegistryImplLookupTest.registerRuntimeBean(new TestingRuntimeBean(), this.baseJMXRegistrator, NAME5);
        ConfigRegistryImplLookupTest.registerRuntimeBean(new TestingRuntimeBean(), this.baseJMXRegistrator, NAME6);
        ConfigRegistryImplLookupTest.registerRuntimeBean(new TestingRuntimeBean(), this.baseJMXRegistrator, NAME8);
        this.baseJMXRegistrator.createTransactionJMXRegistrator("transaction").createTransactionModuleJMXRegistrator().registerMBean((Object)new TestingRuntimeBean(), NAME9);
    }

    private static void registerModuleBean(TestingRuntimeBean testingRuntimeBean, BaseJMXRegistrator baseJMXRegistrator, ObjectName objectName) throws InstanceAlreadyExistsException {
        baseJMXRegistrator.createModuleJMXRegistrator().registerMBean((Object)testingRuntimeBean, objectName);
    }

    private static void registerRuntimeBean(RuntimeBean object, BaseJMXRegistrator baseJMXRegistrator, ObjectName runtimeON) throws InstanceAlreadyExistsException {
        String factoryName = ObjectNameUtil.getFactoryName((ObjectName)runtimeON);
        String instanceName = ObjectNameUtil.getInstanceName((ObjectName)runtimeON);
        Map properties = ObjectNameUtil.getAdditionalPropertiesOfRuntimeBeanName((ObjectName)runtimeON);
        RootRuntimeBeanRegistratorImpl runtimeBeanRegistrator = baseJMXRegistrator.createRuntimeBeanRegistrator(new ModuleIdentifier(factoryName, instanceName));
        Assert.assertThat((Object)properties.isEmpty(), (Matcher)Is.is((Object)true));
        runtimeBeanRegistrator.registerRoot(object);
    }

    @After
    public void cleanUp() {
        this.baseJMXRegistrator.close();
    }

    @Test
    public void testLookupConfigBeans() throws Exception {
        Set beans = this.configRegistryImpl.lookupConfigBeans();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME1, NAME2, NAME3, NAME4}), (Object)beans);
        beans = this.configRegistryImpl.lookupConfigBeans();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME1, NAME2, NAME3, NAME4}), (Object)beans);
    }

    @Test
    public void testLookupConfigBeanWithModuleName() throws Exception {
        Set bean = this.configRegistryImpl.lookupConfigBeans(MODULE_NAMEA);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME1, NAME2, NAME3}), (Object)bean);
    }

    @Test
    public void testLookupConfigBeanWithModuleNameAndInstanceName() throws Exception {
        Set bean = this.configRegistryImpl.lookupConfigBeans(MODULE_NAMEA, INSTANCE_NAMEA);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME1}), (Object)bean);
    }

    @Test
    public void testLookupRuntimeBeans() throws Exception {
        Set beans = this.configRegistryImpl.lookupRuntimeBeans();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME5, NAME6, NAME8}), (Object)beans);
        beans = this.configRegistryImpl.lookupRuntimeBeans(null, null);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME5, NAME6, NAME8}), (Object)beans);
    }

    @Test
    public void testLookupRuntimeBeansWithIFcNameAndImplName() throws Exception {
        Set beans = this.configRegistryImpl.lookupRuntimeBeans(MODULE_NAMEA, INSTANCE_NAMEA);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME5}), (Object)beans);
    }
}

