/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionControllerImpl;
import org.opendaylight.controller.config.manager.impl.ConfigTransactionLookupRegistry;
import org.opendaylight.controller.config.manager.impl.SearchableServiceReferenceWritableRegistry;
import org.opendaylight.controller.config.manager.impl.ServiceReferenceRegistryImpl;
import org.opendaylight.controller.config.manager.impl.TransactionIdentifier;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionModuleJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.runtimembean.TestingRuntimeBean;

public class ConfigTransactionControllerImplTest
extends AbstractLockedPlatformMBeanServerTest {
    private BaseJMXRegistrator baseJMXRegistrator;
    private ConfigTransactionControllerImpl testedTxController;
    private MBeanServer transactionsMBeanServer;
    private static final String TRANSACTION_NAME123 = "testTX1";
    private static final String TRANSACTION_NAME4 = "testTX2";
    private static final String MODULE_NAME124 = "module124";
    private static final String MODULE_NAME3 = "module3";
    private static final String INSTANCE_NAME134 = "instA";
    private static final String INSTANCE_NAME2 = "instB";
    private static final ObjectName NAME1 = ObjectNameUtil.createTransactionModuleON((String)"testTX1", (String)"module124", (String)"instA");
    private static final ObjectName NAME2 = ObjectNameUtil.createTransactionModuleON((String)"testTX1", (String)"module124", (String)"instB");
    private static final ObjectName NAME3 = ObjectNameUtil.createTransactionModuleON((String)"testTX1", (String)"module3", (String)"instA");
    private static final ObjectName NAME4 = ObjectNameUtil.createTransactionModuleON((String)"testTX2", (String)"module124", (String)"instA");

    @Before
    public void setUp() throws Exception {
        this.baseJMXRegistrator = new BaseJMXRegistrator(ManagementFactory.getPlatformMBeanServer());
        this.transactionsMBeanServer = MBeanServerFactory.createMBeanServer();
        HashMap currentlyRegisteredFactories = new HashMap();
        ConfigTransactionLookupRegistry txLookupRegistry = new ConfigTransactionLookupRegistry(new TransactionIdentifier(TRANSACTION_NAME123), () -> this.baseJMXRegistrator.createTransactionJMXRegistrator(TRANSACTION_NAME123), currentlyRegisteredFactories);
        SearchableServiceReferenceWritableRegistry writableRegistry = ServiceReferenceRegistryImpl.createSRWritableRegistry((ServiceReferenceReadableRegistry)ServiceReferenceRegistryImpl.createInitialSRLookupRegistry(), (ConfigTransactionLookupRegistry)txLookupRegistry, currentlyRegisteredFactories);
        this.testedTxController = new ConfigTransactionControllerImpl(txLookupRegistry, 1L, null, 1L, currentlyRegisteredFactories, this.transactionsMBeanServer, ManagementFactory.getPlatformMBeanServer(), false, writableRegistry);
        TransactionModuleJMXRegistrator transactionModuleJMXRegistrator123 = this.testedTxController.getTxModuleJMXRegistrator();
        transactionModuleJMXRegistrator123.registerMBean((Object)new TestingRuntimeBean(), NAME1);
        transactionModuleJMXRegistrator123.registerMBean((Object)new TestingRuntimeBean(), NAME2);
        transactionModuleJMXRegistrator123.registerMBean((Object)new TestingRuntimeBean(), NAME3);
        TransactionJMXRegistrator jmxRegistrator4 = this.baseJMXRegistrator.createTransactionJMXRegistrator(TRANSACTION_NAME4);
        jmxRegistrator4.createTransactionModuleJMXRegistrator().registerMBean((Object)new TestingRuntimeBean(), NAME4);
    }

    @After
    public void cleanUp() {
        this.baseJMXRegistrator.close();
        MBeanServerFactory.releaseMBeanServer(this.transactionsMBeanServer);
    }

    @Test
    public void testLookupConfigBeans() {
        Set beans = this.testedTxController.lookupConfigBeans();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME1, NAME2, NAME3}), (Object)beans);
    }

    @Test
    public void testLookupConfigBeansWithModuleName() {
        Set beans = this.testedTxController.lookupConfigBeans(MODULE_NAME124);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME1, NAME2}), (Object)beans);
    }

    @Test
    public void lookupConfigBeansWithModuleNameAndImplName() throws Exception {
        Set beans = this.testedTxController.lookupConfigBeans(MODULE_NAME124, INSTANCE_NAME134);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{NAME1}), (Object)beans);
    }
}

