/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dynamicmbean;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.JMX;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AbstractDynamicWrapper;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AbstractDynamicWrapperTest;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.DynamicWritableWrapper;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.ReadOnlyAtomicBoolean;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPModule;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolConfigMXBean;
import org.opendaylight.controller.config.spi.Module;

public class DynamicWritableWrapperTest
extends AbstractDynamicWrapperTest {
    private final int newThreadCount = 10;
    private final AtomicBoolean atomicBoolean = new AtomicBoolean();
    private final ReadOnlyAtomicBoolean readOnlyAtomicBoolean = new ReadOnlyAtomicBoolean.ReadOnlyAtomicBooleanImpl(this.atomicBoolean);

    @Override
    protected AbstractDynamicWrapper getDynamicWrapper(Module module, ModuleIdentifier moduleIdentifier) {
        return new DynamicWritableWrapper(module, moduleIdentifier, "transaction-1", this.readOnlyAtomicBoolean, MBeanServerFactory.createMBeanServer(), this.platformMBeanServer);
    }

    @Test
    public void testSetAttribute() throws Exception {
        DynamicMBean proxy = JMX.newMBeanProxy(this.platformMBeanServer, this.threadPoolDynamicWrapperON, DynamicMBean.class);
        proxy.setAttribute(new Attribute("ThreadCount", 10));
        Assert.assertEquals((Object)10, (Object)proxy.getAttribute("ThreadCount"));
        Assert.assertEquals((long)10L, (long)this.threadPoolConfigBean.getThreadCount());
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("ThreadCount", 5));
        boolean bool = true;
        attributeList.add(new Attribute("TriggerNewInstanceCreation", bool));
        proxy.setAttributes(attributeList);
        Assert.assertEquals((long)5L, (long)this.threadPoolConfigBean.getThreadCount());
        Assert.assertEquals((Object)bool, (Object)this.threadPoolConfigBean.isTriggerNewInstanceCreation());
    }

    @Test
    public void testSettersWithMXBeanProxy() {
        TestingFixedThreadPoolConfigMXBean proxy = JMX.newMXBeanProxy(this.platformMBeanServer, this.threadPoolDynamicWrapperON, TestingFixedThreadPoolConfigMXBean.class);
        proxy.setThreadCount(10);
        Assert.assertEquals((long)10L, (long)this.threadPoolConfigBean.getThreadCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObjectNameSetterWithONContainingTransaction_shouldBeTranslatedToReadOnlyON() throws Exception {
        TestingParallelAPSPModuleFactory testingParallelAPSPConfigBeanFactory = new TestingParallelAPSPModuleFactory();
        TestingParallelAPSPModule apspConfigBean = testingParallelAPSPConfigBeanFactory.createModule("", null, null);
        ModuleIdentifier moduleIdentifier2 = new ModuleIdentifier("apsp", "parallel");
        ObjectName dynON2 = ObjectNameUtil.createReadOnlyModuleON((ModuleIdentifier)moduleIdentifier2);
        AbstractDynamicWrapper dyn = this.getDynamicWrapper(apspConfigBean, moduleIdentifier2);
        this.platformMBeanServer.registerMBean(dyn, dynON2);
        try {
            TestingParallelAPSPConfigMXBean proxy = JMX.newMBeanProxy(this.platformMBeanServer, dynON2, TestingParallelAPSPConfigMXBean.class);
            ObjectName withTransactionName = ObjectNameUtil.createTransactionModuleON((String)"transaction1", (String)"moduleName", (String)"instanceName");
            proxy.setThreadPool(withTransactionName);
            ObjectName withoutTransactionName = ObjectNameUtil.withoutTransactionName((ObjectName)withTransactionName);
            Assert.assertEquals((Object)withoutTransactionName, (Object)proxy.getThreadPool());
        }
        finally {
            this.platformMBeanServer.unregisterMBean(dynON2);
        }
    }

    private void setNumberOfThreads(int numberOfThreads) throws Exception {
        DynamicMBean proxy = JMX.newMBeanProxy(this.platformMBeanServer, this.threadPoolDynamicWrapperON, DynamicMBean.class);
        proxy.setAttribute(new Attribute("ThreadCount", numberOfThreads));
    }

    @Test
    public void testDisablingOfWriteOperations() throws Exception {
        this.setNumberOfThreads(10);
        this.atomicBoolean.set(true);
        try {
            this.setNumberOfThreads(10);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Operation is not allowed now", (Object)e.getMessage());
        }
        finally {
            this.atomicBoolean.set(false);
        }
    }
}

