/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.TestingScheduledThreadPoolConfigBeanMXBean;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.TestingScheduledThreadPoolImpl;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.TestingScheduledThreadPoolServiceInterface;
import org.opendaylight.controller.config.spi.Module;

public class TestingScheduledThreadPoolModule
implements Module,
TestingScheduledThreadPoolConfigBeanMXBean,
RuntimeBeanRegistratorAwareModule,
TestingScheduledThreadPoolServiceInterface {
    private final ModuleIdentifier identifier;
    @Nullable
    private final AutoCloseable oldCloseable;
    @Nullable
    private final TestingScheduledThreadPoolImpl oldInstance;
    private int threadCount = 10;
    private TestingScheduledThreadPoolImpl instance;
    private RootRuntimeBeanRegistrator runtimeBeanRegistrator;
    private boolean recreate;

    public TestingScheduledThreadPoolModule(ModuleIdentifier identifier, @Nullable AutoCloseable oldCloseable, @Nullable TestingScheduledThreadPoolImpl oldInstance) {
        this.identifier = identifier;
        this.oldCloseable = oldCloseable;
        this.oldInstance = oldInstance;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator runtimeBeanRegistrator) {
        this.runtimeBeanRegistrator = runtimeBeanRegistrator;
    }

    public void validate() {
        Assert.assertNull((Object)this.runtimeBeanRegistrator);
        Preconditions.checkState((this.threadCount > 0 ? 1 : 0) != 0, (Object)"Parameter 'ThreadCount' must be greater than 0");
    }

    public boolean canReuse(Module oldModule) {
        return this.getClass().isInstance(oldModule) && this.getThreadCount() == ((TestingScheduledThreadPoolModule)oldModule).getThreadCount();
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public Closeable getInstance() {
        Assert.assertNotNull((Object)this.runtimeBeanRegistrator);
        if (this.instance == null) {
            if (this.oldInstance != null && !this.recreate) {
                this.instance = this.oldInstance;
            }
            if (this.instance == null) {
                if (this.oldCloseable != null) {
                    try {
                        this.oldCloseable.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.instance = new TestingScheduledThreadPoolImpl(this.runtimeBeanRegistrator, this.threadCount);
            }
        }
        return this.instance;
    }

    @Override
    public boolean isRecreate() {
        return this.recreate;
    }

    @Override
    public void setRecreate(boolean recreate) {
        this.recreate = recreate;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }
}

