/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.testingservices.threadpool.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.config.manager.impl.AbstractConfigTest;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPool;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.threadpool.test.SimpleConfigurationTest;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class ShutdownTest
extends AbstractConfigTest {
    private final TestingFixedThreadPoolModuleFactory testingFixedThreadPoolModuleFactory = new TestingFixedThreadPoolModuleFactory();
    @Mock
    ModuleFactoriesResolver mockedResolver;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ImmutableMap allFactories = ImmutableMap.of((Object)this.testingFixedThreadPoolModuleFactory.getImplementationName(), (Object)Maps.immutableEntry((Object)this.testingFixedThreadPoolModuleFactory, (Object)this.mockedContext));
        ((ModuleFactoriesResolver)Mockito.doReturn((Object)allFactories).when((Object)this.mockedResolver)).getAllFactories();
        super.initConfigTransactionManagerImpl(this.mockedResolver);
    }

    @Test
    public void testCreateAndDestroyBeanInSameTransaction() throws Exception {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        SimpleConfigurationTest.createFixedThreadPool(transaction);
        transaction.commit();
        Assert.assertEquals((long)1L, (long)TestingFixedThreadPool.ALL_EXECUTORS.size());
        ((ModuleFactoriesResolver)Mockito.doReturn(Collections.emptyMap()).when((Object)this.mockedResolver)).getAllFactories();
        transaction = this.configRegistryClient.createTransaction();
        transaction.commit();
        Assert.assertEquals((long)1L, (long)TestingFixedThreadPool.ALL_EXECUTORS.size());
    }
}

