/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.file.xml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.api.PropertiesProvider;
import org.opendaylight.controller.config.persist.api.StorageAdapter;
import org.opendaylight.controller.config.persist.storage.file.xml.FeatureListProvider;
import org.opendaylight.controller.config.persist.storage.file.xml.model.Config;
import org.opendaylight.controller.config.persist.storage.file.xml.model.ConfigSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFileStorageAdapter
implements StorageAdapter,
Persister {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFileStorageAdapter.class);
    public static final String FILE_STORAGE_PROP = "fileStorage";
    public static final String NUMBER_OF_BACKUPS = "numberOfBackups";
    private static Integer numberOfStoredBackups;
    private File storage;
    private static volatile XmlFileStorageAdapter instance;
    private volatile ConfigSnapshot lastCfgSnapshotCache;
    private volatile Optional<FeatureListProvider> featuresService = Optional.absent();

    @VisibleForTesting
    public void reset() {
        instance = null;
        this.lastCfgSnapshotCache = null;
        this.featuresService = null;
    }

    public Persister instantiate(PropertiesProvider propertiesProvider) {
        if (instance != null) {
            return instance;
        }
        File localStorage = XmlFileStorageAdapter.extractStorageFileFromProperties(propertiesProvider);
        LOG.debug("Using file {}", (Object)localStorage.getAbsolutePath());
        File parentFile = localStorage.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            LOG.debug("Creating parent folders {}", (Object)parentFile);
            parentFile.mkdirs();
        }
        if (!localStorage.exists()) {
            LOG.debug("Storage file does not exist, creating empty file");
            try {
                boolean result = localStorage.createNewFile();
                if (!result) {
                    throw new RuntimeException("Unable to create storage file " + localStorage);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create storage file " + localStorage, e);
            }
        }
        if (numberOfStoredBackups == 0) {
            throw new RuntimeException("numberOfBackups property should be either set to positive value, or ommited. Can not be set to 0.");
        }
        this.setFileStorage(localStorage);
        instance = this;
        return this;
    }

    public static Optional<XmlFileStorageAdapter> getInstance() {
        return Optional.fromNullable((Object)instance);
    }

    public Set<String> getPersistedFeatures() {
        return this.lastCfgSnapshotCache == null ? Collections.emptySet() : this.lastCfgSnapshotCache.getFeatures();
    }

    public void setFeaturesService(FeatureListProvider featuresService) {
        this.featuresService = Optional.of((Object)featuresService);
    }

    @VisibleForTesting
    public void setFileStorage(File storage) {
        this.storage = storage;
    }

    @VisibleForTesting
    public void setNumberOfBackups(Integer numberOfBackups) {
        numberOfStoredBackups = numberOfBackups;
    }

    private static File extractStorageFileFromProperties(PropertiesProvider propertiesProvider) {
        String fileStorageProperty = propertiesProvider.getProperty(FILE_STORAGE_PROP);
        Preconditions.checkNotNull((Object)fileStorageProperty, (Object)("Unable to find " + propertiesProvider.getFullKeyForReporting(FILE_STORAGE_PROP)));
        File result = new File(fileStorageProperty);
        String numberOfBackupsAsString = propertiesProvider.getProperty(NUMBER_OF_BACKUPS);
        numberOfStoredBackups = numberOfBackupsAsString != null ? Integer.valueOf(numberOfBackupsAsString) : Integer.valueOf(Integer.MAX_VALUE);
        LOG.trace("Property {} set to {}", (Object)NUMBER_OF_BACKUPS, (Object)numberOfStoredBackups);
        return result;
    }

    public void persistConfig(ConfigSnapshotHolder holder) throws IOException {
        Preconditions.checkNotNull((Object)this.storage, (Object)"Storage file is null");
        Set<String> installedFeatureIds = Collections.emptySet();
        if (this.featuresService.isPresent()) {
            installedFeatureIds = ((FeatureListProvider)this.featuresService.get()).listFeatures();
        }
        Config cfg = Config.fromXml(this.storage);
        cfg.addConfigSnapshot(ConfigSnapshot.fromConfigSnapshot(holder, installedFeatureIds), numberOfStoredBackups);
        cfg.toXml(this.storage);
    }

    public List<ConfigSnapshotHolder> loadLastConfigs() throws IOException {
        Preconditions.checkNotNull((Object)this.storage, (Object)"Storage file is null");
        if (!this.storage.exists()) {
            return Collections.emptyList();
        }
        Optional<ConfigSnapshot> lastSnapshot = Config.fromXml(this.storage).getLastSnapshot();
        if (lastSnapshot.isPresent()) {
            this.lastCfgSnapshotCache = (ConfigSnapshot)lastSnapshot.get();
            return Lists.newArrayList((Object[])new ConfigSnapshotHolder[]{this.toConfigSnapshot(this.lastCfgSnapshotCache)});
        }
        return Collections.emptyList();
    }

    public ConfigSnapshotHolder toConfigSnapshot(final ConfigSnapshot configSnapshot) {
        return new ConfigSnapshotHolder(){

            public String getConfigSnapshot() {
                return configSnapshot.getConfigSnapshot();
            }

            public SortedSet<String> getCapabilities() {
                return configSnapshot.getCapabilities();
            }

            public String toString() {
                return configSnapshot.toString();
            }
        };
    }

    public void close() {
    }

    public String toString() {
        return "XmlFileStorageAdapter [storage=" + this.storage + "]";
    }
}

