/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.file.xml.model;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.storage.file.xml.model.SnapshotHandler;
import org.opendaylight.controller.config.persist.storage.file.xml.model.StringTrimAdapter;

@XmlRootElement(name="snapshot")
public class ConfigSnapshot {
    public static final String SNAPSHOT_ROOT_ELEMENT_NAME = "snapshot";
    private String configXml;
    private SortedSet<String> capabilities = new TreeSet<String>();
    private Set<String> features = new HashSet<String>();

    ConfigSnapshot(String configXml, SortedSet<String> capabilities) {
        this.configXml = configXml;
        this.capabilities = capabilities;
    }

    ConfigSnapshot(String configXml, SortedSet<String> capabilities, Set<String> features) {
        this.configXml = configXml;
        this.capabilities = capabilities;
        this.features = features;
    }

    ConfigSnapshot() {
    }

    public static ConfigSnapshot fromConfigSnapshot(ConfigSnapshotHolder cfg) {
        return new ConfigSnapshot(cfg.getConfigSnapshot(), cfg.getCapabilities());
    }

    public static ConfigSnapshot fromConfigSnapshot(ConfigSnapshotHolder cfg, Set<String> features) {
        return new ConfigSnapshot(cfg.getConfigSnapshot(), cfg.getCapabilities(), features);
    }

    @XmlAnyElement(value=SnapshotHandler.class)
    public String getConfigSnapshot() {
        return this.configXml;
    }

    public void setConfigSnapshot(String configSnapshot) {
        this.configXml = configSnapshot;
    }

    @XmlElement(name="capability")
    @XmlElementWrapper(name="required-capabilities")
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    public SortedSet<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(SortedSet<String> capabilities) {
        this.capabilities = capabilities;
    }

    @XmlElement(name="feature")
    @XmlElementWrapper(name="features")
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    public Set<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Set<String> features) {
        this.features = features;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConfigSnapshot{");
        sb.append("configSnapshot='").append(this.configXml).append('\'');
        sb.append(", capabilities=").append(this.capabilities);
        sb.append(", features=").append(this.features);
        sb.append('}');
        return sb.toString();
    }
}

