/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.persist.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class CapabilityStrippingConfigSnapshotHolder
implements ConfigSnapshotHolder {
    private static final Logger logger = LoggerFactory.getLogger(CapabilityStrippingConfigSnapshotHolder.class);
    private final String configSnapshot;
    private final StripCapabilitiesResult stripCapabilitiesResult;

    public CapabilityStrippingConfigSnapshotHolder(Element snapshot, Set<String> capabilities, Pattern ignoredMissingCapabilityRegex) {
        XmlElement configElement = XmlElement.fromDomElement((Element)snapshot);
        this.configSnapshot = XmlUtil.toString((Element)configElement.getDomElement());
        this.stripCapabilitiesResult = CapabilityStrippingConfigSnapshotHolder.stripCapabilities(configElement, capabilities, ignoredMissingCapabilityRegex);
    }

    @VisibleForTesting
    static StripCapabilitiesResult stripCapabilities(XmlElement configElement, Set<String> allCapabilitiesFromHello, Pattern ignoredMissingCapabilityRegex) {
        Set<String> foundNamespacesInXML = CapabilityStrippingConfigSnapshotHolder.getNamespaces(configElement);
        logger.trace("All capabilities {}\nFound namespaces in XML {}", allCapabilitiesFromHello, foundNamespacesInXML);
        TreeSet<String> requiredCapabilities = new TreeSet<String>();
        HashSet<String> obsoleteCapabilities = new HashSet<String>();
        TreeSet<String> missingNamespaces = new TreeSet<String>(foundNamespacesInXML);
        for (String capability : allCapabilitiesFromHello) {
            String namespace = capability.replaceAll("\\?.*", "");
            if (foundNamespacesInXML.contains(namespace)) {
                requiredCapabilities.add(capability);
                Preconditions.checkState((boolean)missingNamespaces.remove(namespace));
                continue;
            }
            obsoleteCapabilities.add(capability);
        }
        logger.trace("Required capabilities {}, \nObsolete capabilities {}", requiredCapabilities, obsoleteCapabilities);
        Iterator iterator = missingNamespaces.iterator();
        while (iterator.hasNext()) {
            String capability;
            capability = (String)iterator.next();
            if (!ignoredMissingCapabilityRegex.matcher(capability).matches()) continue;
            logger.trace("Ignoring missing capability {}", (Object)capability);
            iterator.remove();
        }
        if (missingNamespaces.size() > 0) {
            logger.warn("Some capabilities are missing: {}", missingNamespaces);
        }
        return new StripCapabilitiesResult(requiredCapabilities, missingNamespaces);
    }

    static Set<String> getNamespaces(XmlElement element) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry attribute : element.getAttributes().entrySet()) {
            if (!((String)attribute.getKey()).startsWith("xmlns")) continue;
            result.add(((Attr)attribute.getValue()).getValue());
        }
        for (XmlElement child : element.getChildElements()) {
            result.addAll(CapabilityStrippingConfigSnapshotHolder.getNamespaces(child));
        }
        return result;
    }

    public SortedSet<String> getCapabilities() {
        return this.stripCapabilitiesResult.requiredCapabilities;
    }

    @VisibleForTesting
    Set<String> getMissingNamespaces() {
        return this.stripCapabilitiesResult.missingNamespaces;
    }

    public String getConfigSnapshot() {
        return this.configSnapshot;
    }

    private static class StripCapabilitiesResult {
        private final SortedSet<String> requiredCapabilities;
        private final SortedSet<String> missingNamespaces;

        private StripCapabilitiesResult(SortedSet<String> requiredCapabilities, SortedSet<String> missingNamespaces) {
            this.requiredCapabilities = Collections.unmodifiableSortedSet(requiredCapabilities);
            this.missingNamespaces = Collections.unmodifiableSortedSet(missingNamespaces);
        }
    }
}

