/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.persist.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.netconf.api.jmx.CommitJMXNotification;
import org.opendaylight.controller.netconf.api.jmx.DefaultCommitOperationMXBean;
import org.opendaylight.controller.netconf.api.jmx.NetconfJMXNotification;
import org.opendaylight.controller.netconf.client.NetconfClient;
import org.opendaylight.controller.netconf.persist.impl.CapabilityStrippingConfigSnapshotHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConfigPersisterNotificationHandler
implements NotificationListener,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPersisterNotificationHandler.class);
    private final MBeanServerConnection mBeanServerConnection;
    private final NetconfClient netconfClient;
    private final Persister persisterAggregator;
    private final Pattern ignoredMissingCapabilityRegex;

    public ConfigPersisterNotificationHandler(MBeanServerConnection mBeanServerConnection, NetconfClient netconfClient, Persister persisterAggregator, Pattern ignoredMissingCapabilityRegex) {
        this.mBeanServerConnection = mBeanServerConnection;
        this.netconfClient = netconfClient;
        this.persisterAggregator = persisterAggregator;
        this.ignoredMissingCapabilityRegex = ignoredMissingCapabilityRegex;
    }

    public void init() {
        this.registerAsJMXListener();
    }

    private void registerAsJMXListener() {
        logger.trace("Called registerAsJMXListener");
        try {
            this.mBeanServerConnection.addNotificationListener(DefaultCommitOperationMXBean.objectName, this, null, null);
        }
        catch (IOException | InstanceNotFoundException e) {
            throw new RuntimeException("Cannot register as JMX listener to netconf", e);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!(notification instanceof NetconfJMXNotification)) {
            return;
        }
        logger.trace("Received notification {}", (Object)notification);
        if (notification instanceof CommitJMXNotification) {
            try {
                this.handleAfterCommitNotification((CommitJMXNotification)notification);
            }
            catch (Throwable e) {
                logger.warn("Exception occured during notification handling: ", e);
                throw e;
            }
        } else {
            throw new IllegalStateException("Unknown config registry notification type " + notification);
        }
    }

    private void handleAfterCommitNotification(CommitJMXNotification notification) {
        try {
            this.persisterAggregator.persistConfig((ConfigSnapshotHolder)new CapabilityStrippingConfigSnapshotHolder(notification.getConfigSnapshot(), notification.getCapabilities(), this.ignoredMissingCapabilityRegex));
            logger.trace("Configuration persisted successfully");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to persist configuration snapshot", e);
        }
    }

    @Override
    public synchronized void close() {
        ObjectName on = DefaultCommitOperationMXBean.objectName;
        try {
            if (this.mBeanServerConnection.isRegistered(on)) {
                this.mBeanServerConnection.removeNotificationListener(on, this);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to unregister {} as listener for {}", new Object[]{this, on, e});
        }
    }

    public NetconfClient getNetconfClient() {
        return this.netconfClient;
    }
}

