/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.persist.impl.osgi;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import org.opendaylight.controller.netconf.client.NetconfClient;
import org.opendaylight.controller.netconf.persist.impl.ConfigPersisterNotificationHandler;
import org.opendaylight.controller.netconf.persist.impl.ConfigPusher;
import org.opendaylight.controller.netconf.persist.impl.PersisterAggregator;
import org.opendaylight.controller.netconf.persist.impl.Util;
import org.opendaylight.controller.netconf.persist.impl.osgi.PropertiesProviderBaseImpl;
import org.opendaylight.controller.netconf.util.osgi.NetconfConfigUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPersisterActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPersisterActivator.class);
    private static final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String IGNORED_MISSING_CAPABILITY_REGEX_SUFFIX = "ignoredMissingCapabilityRegex";
    private static final String PUSH_TIMEOUT = "pushTimeout";
    public static final String NETCONF_CONFIG_PERSISTER = "netconf.config.persister";
    public static final String STORAGE_ADAPTER_CLASS_PROP_SUFFIX = "storageAdapterClass";
    public static final String DEFAULT_IGNORED_REGEX = "^urn:ietf:params:xml:ns:netconf:base:1.0";
    private volatile ConfigPersisterNotificationHandler jmxNotificationHandler;
    private volatile NetconfClient netconfClient;
    private Thread initializationThread;
    private EventLoopGroup nettyThreadgroup;
    private PersisterAggregator persisterAggregator;

    public void start(BundleContext context) throws Exception {
        logger.debug("ConfigPersister starting");
        PropertiesProviderBaseImpl propertiesProvider = new PropertiesProviderBaseImpl(context);
        String regexProperty = propertiesProvider.getProperty(IGNORED_MISSING_CAPABILITY_REGEX_SUFFIX);
        String regex = regexProperty != null ? regexProperty : DEFAULT_IGNORED_REGEX;
        String timeoutProperty = propertiesProvider.getProperty(PUSH_TIMEOUT);
        long timeout = timeoutProperty == null ? ConfigPusher.DEFAULT_TIMEOUT : TimeUnit.SECONDS.toNanos(Integer.valueOf(timeoutProperty).intValue());
        final Pattern ignoredMissingCapabilityRegex = Pattern.compile(regex);
        this.nettyThreadgroup = new NioEventLoopGroup();
        this.persisterAggregator = PersisterAggregator.createFromProperties(propertiesProvider);
        InetSocketAddress address = NetconfConfigUtil.extractTCPNetconfAddress((BundleContext)context, (String)"Netconf is not configured, persister is not operational", (boolean)true);
        final ConfigPusher configPusher = new ConfigPusher(address, this.nettyThreadgroup);
        Runnable initializationRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ConfigPersisterActivator.this.netconfClient = configPusher.init(ConfigPersisterActivator.this.persisterAggregator.loadLastConfigs());
                    ConfigPersisterActivator.this.jmxNotificationHandler = new ConfigPersisterNotificationHandler(platformMBeanServer, ConfigPersisterActivator.this.netconfClient, ConfigPersisterActivator.this.persisterAggregator, ignoredMissingCapabilityRegex);
                    ConfigPersisterActivator.this.jmxNotificationHandler.init();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Interrupted while waiting for netconf connection");
                    throw new RuntimeException("Interrupted while waiting for netconf connection", e);
                }
                logger.info("Configuration Persister initialization completed.");
            }
        };
        this.initializationThread = new Thread(initializationRunnable, "ConfigPersister-registrator");
        this.initializationThread.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.initializationThread.interrupt();
        if (this.jmxNotificationHandler != null) {
            this.jmxNotificationHandler.close();
        }
        if (this.netconfClient != null) {
            this.netconfClient = this.jmxNotificationHandler.getNetconfClient();
            try {
                Util.closeClientAndDispatcher(this.netconfClient);
            }
            catch (Exception e) {
                logger.warn("Unable to close connection to netconf {}", (Object)this.netconfClient, (Object)e);
            }
        }
        this.nettyThreadgroup.shutdownGracefully();
        this.persisterAggregator.close();
    }
}

