/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.persist.impl.osgi;

import org.opendaylight.controller.config.persist.api.PropertiesProvider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesProviderBaseImpl
implements PropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesProviderBaseImpl.class);
    private final BundleContext bundleContext;

    public PropertiesProviderBaseImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getProperty(String key) {
        String fullKey = this.getFullKeyForReporting(key);
        return this.getPropertyWithoutPrefix(fullKey);
    }

    public String getPropertyWithoutPrefix(String fullKey) {
        logger.trace("Full key {}", (Object)fullKey);
        return this.bundleContext.getProperty(fullKey);
    }

    public String getPrefix() {
        return "netconf.config.persister";
    }

    public String getFullKeyForReporting(String key) {
        return this.getPrefix() + "." + key;
    }
}

