/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.AbstractActor;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActorWithMetering;
import org.opendaylight.controller.cluster.reporting.MetricsReporter;
import scala.PartialFunction;
import scala.runtime.AbstractPartialFunction;
import scala.runtime.BoxedUnit;

public class MeteringBehavior
extends AbstractPartialFunction<Object, BoxedUnit> {
    public static final String DOMAIN = "org.opendaylight.controller.actor.metric";
    private static final String MSG_PROCESSING_RATE = "msg-rate";
    private final MetricRegistry metricRegistry = MetricsReporter.getInstance("org.opendaylight.controller.actor.metric").getMetricsRegistry();
    private final String actorQualifiedName;
    private final Timer msgProcessingTimer;
    private final PartialFunction<Object, BoxedUnit> receive;

    private MeteringBehavior(String actorName, AbstractActor meteredActor) {
        this.actorQualifiedName = meteredActor.getSelf().path().parent().toStringWithoutAddress() + "/" + actorName;
        this.msgProcessingTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.actorQualifiedName, (String[])new String[]{MSG_PROCESSING_RATE}));
        this.receive = meteredActor.createReceive().onMessage();
    }

    public MeteringBehavior(AbstractUntypedActorWithMetering actor) {
        this(actor.getActorNameOverride() != null ? actor.getActorNameOverride() : actor.getSelf().path().name(), actor);
    }

    public MeteringBehavior(AbstractActor actor) {
        this(actor.getSelf().path().name(), actor);
    }

    public boolean isDefinedAt(Object obj) {
        return this.receive.isDefinedAt(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoxedUnit apply(Object message) {
        String messageType = message.getClass().getSimpleName();
        String msgProcessingTimeByMsgType = MetricRegistry.name((String)this.actorQualifiedName, (String[])new String[]{MSG_PROCESSING_RATE, messageType});
        Timer msgProcessingTimerByMsgType = this.metricRegistry.timer(msgProcessingTimeByMsgType);
        Timer.Context context = this.msgProcessingTimer.time();
        Timer.Context contextByMsgType = msgProcessingTimerByMsgType.time();
        try {
            BoxedUnit boxedUnit = (BoxedUnit)this.receive.apply(message);
            return boxedUnit;
        }
        finally {
            contextByMsgType.stop();
            context.stop();
        }
    }
}

