/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.transformer;

import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.ReusableNormalizedNodePruner;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UintAdaptingPruner
extends ReusableNormalizedNodePruner {
    private static final LoadingCache<ListSchemaNode, NipAdapter> NIP_ADAPTERS = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new AdapterCacheLoader());

    UintAdaptingPruner(DataSchemaContextTree tree) {
        super(tree);
    }

    @Override
    public ReusableNormalizedNodePruner duplicate() {
        return new UintAdaptingPruner(this.getTree());
    }

    @Override
    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.enter(this::adaptEntry, identifier, childSizeHint);
    }

    @Override
    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.enter(this::adaptEntry, name);
    }

    @Override
    Object translateScalar(DataSchemaContext context, Object value) {
        Object object;
        DataSchemaNode schema = context.dataSchemaNode();
        if (schema instanceof TypedDataSchemaNode) {
            TypedDataSchemaNode typed = (TypedDataSchemaNode)schema;
            object = UintAdaptingPruner.adaptValue(typed.getType(), value);
        } else {
            object = value;
        }
        return object;
    }

    private void adaptEntry(ReusableImmutableNormalizedNodeStreamWriter writer, YangInstanceIdentifier.NodeWithValue<?> name) {
        YangInstanceIdentifier.NodeWithValue adapted;
        DataSchemaNode schema = this.currentSchema().dataSchemaNode();
        if (schema instanceof TypedDataSchemaNode) {
            TypedDataSchemaNode typed = (TypedDataSchemaNode)schema;
            Object oldValue = name.getValue();
            Object newValue = UintAdaptingPruner.adaptValue(typed.getType(), oldValue);
            adapted = newValue == oldValue ? name : new YangInstanceIdentifier.NodeWithValue(name.getNodeType(), newValue);
        } else {
            adapted = name;
        }
        writer.startLeafSetEntryNode(adapted);
    }

    private void adaptEntry(ReusableImmutableNormalizedNodeStreamWriter writer, YangInstanceIdentifier.NodeIdentifierWithPredicates name, int size) {
        YangInstanceIdentifier.NodeIdentifierWithPredicates adapted;
        DataSchemaNode schema = this.currentSchema().dataSchemaNode();
        if (schema instanceof ListSchemaNode) {
            ListSchemaNode list = (ListSchemaNode)schema;
            adapted = (YangInstanceIdentifier.NodeIdentifierWithPredicates)((NipAdapter)NIP_ADAPTERS.getUnchecked((Object)list)).apply(name);
        } else {
            adapted = name;
        }
        writer.startMapEntryNode(adapted, size);
    }

    private static Object adaptValue(TypeDefinition<?> type, Object value) {
        ValueAdapter adapter = ValueAdapter.forType(type);
        return adapter != null ? adapter.apply(value) : value;
    }

    @FunctionalInterface
    private static interface NipAdapter
    extends Function<YangInstanceIdentifier.NodeIdentifierWithPredicates, YangInstanceIdentifier.NodeIdentifierWithPredicates> {
    }

    private static enum ValueAdapter implements Function<Object, Object>
    {
        UINT8{

            @Override
            public Object apply(Object obj) {
                if (obj instanceof Short) {
                    Short shortObj = (Short)obj;
                    LOG.trace("Translating legacy uint8 {}", obj);
                    return Uint8.valueOf((short)shortObj);
                }
                return obj;
            }
        }
        ,
        UINT16{

            @Override
            public Object apply(Object obj) {
                if (obj instanceof Integer) {
                    Integer intObj = (Integer)obj;
                    LOG.trace("Translating legacy uint16 {}", obj);
                    return Uint16.valueOf((int)intObj);
                }
                return obj;
            }
        }
        ,
        UINT32{

            @Override
            public Object apply(Object obj) {
                if (obj instanceof Long) {
                    Long longObj = (Long)obj;
                    LOG.trace("Translating legacy uint32 {}", obj);
                    return Uint32.valueOf((long)longObj);
                }
                return obj;
            }
        }
        ,
        UINT64{

            @Override
            public Object apply(Object obj) {
                if (obj instanceof BigInteger) {
                    BigInteger bigInt = (BigInteger)obj;
                    LOG.trace("Translating legacy uint64 {}", obj);
                    return Uint64.valueOf((BigInteger)bigInt);
                }
                return obj;
            }
        };

        private static final Logger LOG;

        static @Nullable ValueAdapter forType(TypeDefinition<?> type) {
            if (type instanceof Uint8TypeDefinition) {
                return UINT8;
            }
            if (type instanceof Uint16TypeDefinition) {
                return UINT16;
            }
            if (type instanceof Uint32TypeDefinition) {
                return UINT32;
            }
            if (type instanceof Uint64TypeDefinition) {
                return UINT64;
            }
            return null;
        }

        static {
            LOG = LoggerFactory.getLogger(ValueAdapter.class);
        }
    }

    private static final class AdapterCacheLoader
    extends CacheLoader<ListSchemaNode, NipAdapter> {
        private AdapterCacheLoader() {
        }

        public NipAdapter load(ListSchemaNode key) {
            HashMap<QName, ValueAdapter> adapters = new HashMap<QName, ValueAdapter>();
            for (QName qname : key.getKeyDefinition()) {
                DataSchemaNode child;
                try {
                    child = (DataSchemaNode)key.findDataTreeChild(qname).orElseThrow();
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException("Failed to find child " + String.valueOf(qname), e);
                }
                Verify.verify((boolean)(child instanceof LeafSchemaNode), (String)"Key references non-leaf child %s", (Object)child);
                ValueAdapter adapter = ValueAdapter.forType(((LeafSchemaNode)child).getType());
                if (adapter == null) continue;
                adapters.put(qname, adapter);
            }
            return adapters.isEmpty() ? name -> name : new TransformingNipAdapter(adapters);
        }
    }

    private static final class TransformingNipAdapter
    implements NipAdapter {
        private final ImmutableMap<QName, ValueAdapter> adapters;

        TransformingNipAdapter(Map<QName, ValueAdapter> toTransform) {
            this.adapters = ImmutableMap.copyOf(toTransform);
        }

        @Override
        public YangInstanceIdentifier.NodeIdentifierWithPredicates apply(YangInstanceIdentifier.NodeIdentifierWithPredicates name) {
            Set entries = name.entrySet();
            ImmutableMap.Builder newEntries = ImmutableMap.builderWithExpectedSize((int)entries.size());
            for (Map.Entry e : entries) {
                QName qname;
                ValueAdapter adapter = (ValueAdapter)this.adapters.get((Object)(qname = (QName)e.getKey()));
                newEntries.put((Object)qname, adapter != null ? adapter.apply(e.getValue()) : e.getValue());
            }
            return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)name.getNodeType(), (Map)newEntries.build());
        }
    }
}

