/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.io;

import com.google.common.io.ByteSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackedOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(FileBackedOutputStream.class);
    private static final Cleaner FILE_CLEANER = Cleaner.create();
    private final int fileThreshold;
    private final String fileDirectory;
    private @GuardedBy(value={"this"}) MemoryOutputStream memory = new MemoryOutputStream();
    private @GuardedBy(value={"this"}) OutputStream out = this.memory;
    private @GuardedBy(value={"this"}) File file;
    private @GuardedBy(value={"this"}) Cleaner.Cleanable fileCleanup;
    private @GuardedBy(value={"this"}) ByteSource source;
    private volatile long count;

    public FileBackedOutputStream(int fileThreshold, @Nullable String fileDirectory) {
        this.fileThreshold = fileThreshold;
        this.fileDirectory = fileDirectory;
    }

    public synchronized @NonNull ByteSource asByteSource() throws IOException {
        this.close();
        if (this.source == null) {
            this.source = new ByteSource(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public InputStream openStream() throws IOException {
                    FileBackedOutputStream fileBackedOutputStream = FileBackedOutputStream.this;
                    synchronized (fileBackedOutputStream) {
                        if (FileBackedOutputStream.this.file != null) {
                            return Files.newInputStream(FileBackedOutputStream.this.file.toPath(), new OpenOption[0]);
                        }
                        return new ByteArrayInputStream(FileBackedOutputStream.this.memory.buf(), 0, FileBackedOutputStream.this.memory.count());
                    }
                }

                public long size() {
                    return FileBackedOutputStream.this.count;
                }
            };
        }
        return this.source;
    }

    @Override
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Findbugs erroneously complains that the increment of count needs to be atomic even though it is inside a synchronized block.")
    public synchronized void write(int value) throws IOException {
        this.possiblySwitchToFile(1);
        this.out.write(value);
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public synchronized void write(byte[] bytes, int off, int len) throws IOException {
        this.possiblySwitchToFile(len);
        this.out.write(bytes, off, len);
        this.count += (long)len;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.out != null) {
            OutputStream closeMe = this.out;
            this.out = null;
            closeMe.close();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public synchronized long getCount() {
        return this.count;
    }

    public synchronized void cleanup() {
        LOG.debug("In cleanup");
        this.closeQuietly();
        if (this.fileCleanup != null) {
            this.fileCleanup.clean();
        }
        this.file = null;
    }

    @Holding(value={"this"})
    private void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing output stream {}", (Object)this.out, (Object)e);
        }
    }

    @Holding(value={"this"})
    private void possiblySwitchToFile(int len) throws IOException {
        if (this.out == null) {
            throw new IOException("Stream already closed");
        }
        if (this.file == null && this.memory.count() + len > this.fileThreshold) {
            OutputStream transfer;
            File temp = File.createTempFile("FileBackedOutputStream", null, this.fileDirectory == null ? null : new File(this.fileDirectory));
            temp.deleteOnExit();
            Cleaner.Cleanable cleanup = FILE_CLEANER.register(this, () -> FileBackedOutputStream.deleteFile(temp));
            LOG.debug("Byte count {} has exceeded threshold {} - switching to file: {}", new Object[]{this.memory.count() + len, this.fileThreshold, temp});
            try {
                transfer = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
                try {
                    transfer.write(this.memory.buf(), 0, this.memory.count());
                    transfer.flush();
                }
                catch (IOException e) {
                    try {
                        transfer.close();
                    }
                    catch (IOException ex) {
                        LOG.debug("Error closing temp file {}", (Object)temp, (Object)ex);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                cleanup.clean();
                throw e;
            }
            this.out = transfer;
            this.file = temp;
            this.fileCleanup = cleanup;
            this.memory = null;
        }
    }

    private static void deleteFile(File file) {
        LOG.debug("Deleting temp file {}", (Object)file);
        if (!file.delete()) {
            LOG.warn("Could not delete temp file {}", (Object)file);
        }
    }

    private static final class MemoryOutputStream
    extends ByteArrayOutputStream {
        private MemoryOutputStream() {
        }

        byte[] buf() {
            return this.buf;
        }

        int count() {
            return this.count;
        }
    }
}

