/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.reporting;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

public class MetricsReporter
implements AutoCloseable {
    private static final LoadingCache<String, MetricsReporter> METRIC_REPORTERS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, MetricsReporter>(){

        public MetricsReporter load(String domainName) {
            return new MetricsReporter(domainName);
        }
    });
    private final String domainName;
    private final JmxReporter jmxReporter;
    private final MetricRegistry metricRegistry = new MetricRegistry();

    MetricsReporter(String domainName) {
        this.domainName = domainName;
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain(domainName).build();
        this.jmxReporter.start();
    }

    public static MetricsReporter getInstance(String domainName) {
        return (MetricsReporter)METRIC_REPORTERS.getUnchecked((Object)domainName);
    }

    public MetricRegistry getMetricsRegistry() {
        return this.metricRegistry;
    }

    @Override
    public void close() {
        this.jmxReporter.close();
        METRIC_REPORTERS.invalidate((Object)this.domainName);
    }
}

