/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.schema.provider.impl;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.opendaylight.controller.cluster.schema.provider.RemoteYangTextSourceProvider;
import org.opendaylight.controller.cluster.schema.provider.impl.YangTextSchemaSourceSerializationProxy;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;
import scala.concurrent.Promise;

@Beta
public class RemoteYangTextSourceProviderImpl
implements RemoteYangTextSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteYangTextSourceProviderImpl.class);
    private final SchemaRepository repository;
    private final Set<SourceIdentifier> providedSources;

    public RemoteYangTextSourceProviderImpl(SchemaRepository repository, Set<SourceIdentifier> providedSources) {
        this.repository = Objects.requireNonNull(repository);
        this.providedSources = providedSources;
    }

    @Override
    public Future<Set<SourceIdentifier>> getProvidedSources() {
        return akka.dispatch.Futures.successful(this.providedSources);
    }

    @Override
    public Future<YangTextSchemaSourceSerializationProxy> getYangTextSchemaSource(SourceIdentifier identifier) {
        LOG.trace("Sending yang schema source for {}", (Object)identifier);
        final Promise promise = akka.dispatch.Futures.promise();
        ListenableFuture future = this.repository.getSchemaSource(identifier, YangTextSource.class);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<YangTextSource>(){

            public void onSuccess(YangTextSource result) {
                try {
                    promise.success((Object)new YangTextSchemaSourceSerializationProxy(result));
                }
                catch (IOException e) {
                    LOG.warn("Unable to read schema source for {}", (Object)result.sourceId(), (Object)e);
                    promise.failure((Throwable)e);
                }
            }

            public void onFailure(Throwable failure) {
                LOG.warn("Unable to retrieve schema source from provider", failure);
                promise.failure(failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return promise.future();
    }
}

