/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.schema.provider.impl;

import com.google.common.annotations.Beta;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.Serializable;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.spi.source.DelegatedYangTextSource;

@Beta
public class YangTextSchemaSourceSerializationProxy
implements Serializable {
    private static final long serialVersionUID = -6361268518176019477L;
    private final String schemaSource;
    private final Revision revision;
    private final String name;

    public YangTextSchemaSourceSerializationProxy(YangTextSource source) throws IOException {
        SourceIdentifier sourceId = source.sourceId();
        this.revision = sourceId.revision();
        this.name = sourceId.name().getLocalName();
        this.schemaSource = source.read();
    }

    public YangTextSource getRepresentation() {
        return new DelegatedYangTextSource(new SourceIdentifier(UnresolvedQName.Unqualified.of((String)this.name), this.revision), CharSource.wrap((CharSequence)this.schemaSource));
    }
}

