/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ForwardingObject;
import java.util.Dictionary;
import java.util.Map;
import java.util.function.Consumer;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(factory="org.opendaylight.mdsal.dom.schema.osgi.impl.SchemaSchemaContextListener", service={ModelContextListener.class})
public final class ModelContextListener
extends ForwardingObject {
    static final String FACTORY_NAME = "org.opendaylight.mdsal.dom.schema.osgi.impl.SchemaSchemaContextListener";
    private static final Logger LOG = LoggerFactory.getLogger(ModelContextListener.class);
    @VisibleForTesting
    static final String DELEGATE = "org.opendaylight.mdsal.dom.schema.osgi.SchemaSchemaContextListener";
    private Consumer<EffectiveModelContext> delegate = null;

    @Activate
    public ModelContextListener(Map<String, ?> properties) {
        this.delegate = (Consumer)Verify.verifyNotNull(properties.get(DELEGATE));
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
    }

    protected Object delegate() {
        return this.delegate;
    }

    void onModelContextUpdated(EffectiveModelContext modelContext) {
        LOG.trace("Notifying {} of {}", this.delegate, (Object)modelContext);
        try {
            this.delegate.accept(modelContext);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to notify listener {}", this.delegate, (Object)e);
        }
    }

    static Dictionary<String, ?> props(Consumer<EffectiveModelContext> delegate) {
        return FrameworkUtil.asDictionary(Map.of(DELEGATE, delegate));
    }
}

