/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NoopDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;

abstract class AbstractDataTreeTip
implements DataTreeTip {
    AbstractDataTreeTip() {
    }

    protected abstract @NonNull TreeNode getTipRoot();

    abstract @NonNull YangInstanceIdentifier getRootPath();

    public final void validate(DataTreeModification modification) throws DataValidationFailedException {
        InMemoryDataTreeModification m = AbstractDataTreeTip.accessMod(modification, "validate");
        m.getStrategy().checkApplicable(new ModificationPath(this.getRootPath()), m.getRootModification(), this.getTipRoot(), m.getVersion());
    }

    public final DataTreeCandidateTip prepare(DataTreeModification modification) {
        InMemoryDataTreeModification m = AbstractDataTreeTip.accessMod(modification, "prepare");
        ModifiedNode root = m.getRootModification();
        TreeNode currentRoot = this.getTipRoot();
        if (root.getOperation() == LogicalOperation.NONE) {
            return new NoopDataTreeCandidate(YangInstanceIdentifier.of(), root, currentRoot);
        }
        TreeNode newRoot = m.getStrategy().apply(m.getRootModification(), currentRoot, m.getVersion());
        if (newRoot == null) {
            throw new IllegalStateException("Apply strategy failed to produce root node for modification " + String.valueOf(modification));
        }
        return new InMemoryDataTreeCandidate(YangInstanceIdentifier.of(), root, currentRoot, newRoot);
    }

    private static @NonNull InMemoryDataTreeModification accessMod(DataTreeModification mod, String op) {
        if (mod instanceof InMemoryDataTreeModification) {
            InMemoryDataTreeModification inMemoryMod = (InMemoryDataTreeModification)mod;
            if (inMemoryMod.isSealed()) {
                return inMemoryMod;
            }
            throw new IllegalArgumentException("Attempted to " + op + " unsealed modification " + String.valueOf(inMemoryMod));
        }
        throw new IllegalArgumentException("Invalid modification " + String.valueOf(mod.getClass()));
    }
}

