/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.spi.AbstractDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;

abstract class AbstractModifiedNodeBasedCandidateNode
extends AbstractDataTreeCandidateNode {
    private final ModifiedNode mod;
    private final TreeNode newMeta;
    private final TreeNode oldMeta;

    protected AbstractModifiedNodeBasedCandidateNode(ModifiedNode mod, TreeNode oldMeta, TreeNode newMeta) {
        super((ModificationType)Verify.verifyNotNull((Object)mod.getModificationType(), (String)"Node %s does not have resolved modification type", (Object[])new Object[]{mod}));
        this.newMeta = newMeta;
        this.oldMeta = oldMeta;
        this.mod = mod;
    }

    protected final ModifiedNode getMod() {
        return this.mod;
    }

    protected final TreeNode getNewMeta() {
        return this.newMeta;
    }

    protected final TreeNode getOldMeta() {
        return this.oldMeta;
    }

    private static TreeNode childMeta(TreeNode parent, YangInstanceIdentifier.PathArgument id) {
        return parent == null ? null : (TreeNode)parent.childByArg(id);
    }

    private static boolean canHaveChildren(@Nullable TreeNode oldMeta, @Nullable TreeNode newMeta) {
        return oldMeta != null && oldMeta.data() instanceof NormalizedNodeContainer || newMeta != null && newMeta.data() instanceof NormalizedNodeContainer;
    }

    private static DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode> getContainer(@Nullable TreeNode meta) {
        return meta == null ? null : (DistinctNodeContainer)meta.data();
    }

    private @NonNull ChildNode childNode(ModifiedNode childMod) {
        YangInstanceIdentifier.PathArgument id = childMod.getIdentifier();
        return new ChildNode(childMod, AbstractModifiedNodeBasedCandidateNode.childMeta(this.oldMeta, id), AbstractModifiedNodeBasedCandidateNode.childMeta(this.newMeta, id));
    }

    public Collection<DataTreeCandidateNode> childNodes() {
        return switch (this.mod.getModificationType()) {
            default -> throw new MatchException(null, null);
            case ModificationType.APPEARED, ModificationType.DISAPPEARED, ModificationType.SUBTREE_MODIFIED -> Collections2.transform(this.mod.getChildren(), this::childNode);
            case ModificationType.UNMODIFIED -> {
                if (!AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta)) {
                    yield ImmutableList.of();
                }
                yield Collections2.transform((Collection)AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta != null ? this.newMeta : this.oldMeta).body(), DataTreeCandidateNodes::unmodified);
            }
            case ModificationType.DELETE, ModificationType.WRITE -> !AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta) ? ImmutableList.of() : DataTreeCandidateNodes.containerDelta(AbstractModifiedNodeBasedCandidateNode.getContainer(this.oldMeta), AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta));
        };
    }

    public final NormalizedNode dataBefore() {
        return AbstractModifiedNodeBasedCandidateNode.data(this.oldMeta);
    }

    public final NormalizedNode dataAfter() {
        return AbstractModifiedNodeBasedCandidateNode.data(this.newMeta);
    }

    private static @Nullable NormalizedNode data(TreeNode meta) {
        return meta == null ? null : meta.data();
    }

    public final DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
        YangInstanceIdentifier.PathArgument identifier = Objects.requireNonNull(childName);
        return switch (this.mod.getModificationType()) {
            default -> throw new MatchException(null, null);
            case ModificationType.APPEARED, ModificationType.DISAPPEARED, ModificationType.SUBTREE_MODIFIED -> {
                ModifiedNode child = this.mod.childByArg(identifier);
                if (child == null) {
                    yield null;
                }
                yield this.childNode(child);
            }
            case ModificationType.UNMODIFIED -> {
                if (!AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta)) {
                    yield null;
                }
                NormalizedNode child = AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta != null ? this.newMeta : this.oldMeta).childByArg(identifier);
                if (child == null) {
                    yield null;
                }
                yield DataTreeCandidateNodes.unmodified((NormalizedNode)child);
            }
            case ModificationType.DELETE, ModificationType.WRITE -> !AbstractModifiedNodeBasedCandidateNode.canHaveChildren(this.oldMeta, this.newMeta) ? null : DataTreeCandidateNodes.containerDelta(AbstractModifiedNodeBasedCandidateNode.getContainer(this.oldMeta), AbstractModifiedNodeBasedCandidateNode.getContainer(this.newMeta), (YangInstanceIdentifier.PathArgument)identifier);
        };
    }

    protected final MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.omitNullValues().add("oldMeta", (Object)this.oldMeta).add("newMeta", (Object)this.newMeta);
    }

    private static final class ChildNode
    extends AbstractModifiedNodeBasedCandidateNode {
        ChildNode(ModifiedNode mod, TreeNode oldMeta, TreeNode newMeta) {
            super(mod, oldMeta, newMeta);
        }

        public YangInstanceIdentifier.PathArgument name() {
            return this.getMod().getIdentifier();
        }
    }
}

