/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.MinMaxElementsValidation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.UniqueValidation;
import org.opendaylight.yangtools.yang.data.tree.impl.ValidatedTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract sealed class AbstractValidation
extends ModificationApplyOperation
permits MinMaxElementsValidation, UniqueValidation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractValidation.class);
    private final @NonNull ModificationApplyOperation delegate;

    AbstractValidation(ModificationApplyOperation delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public final ModificationApplyOperation childByArg(YangInstanceIdentifier.PathArgument arg) {
        return this.delegate.childByArg(arg);
    }

    @Override
    final ChildTrackingPolicy getChildPolicy() {
        return this.delegate.getChildPolicy();
    }

    @Override
    final void mergeIntoModifiedNode(ModifiedNode node, NormalizedNode value, Version version) {
        this.delegate.mergeIntoModifiedNode(node, value, version);
    }

    @Override
    final void quickVerifyStructure(NormalizedNode modification) {
        this.delegate.quickVerifyStructure(modification);
    }

    @Override
    final void recursivelyVerifyStructure(NormalizedNode value) {
        this.delegate.recursivelyVerifyStructure(value);
    }

    @Override
    final TreeNode apply(ModifiedNode modification, TreeNode currentMeta, Version version) {
        ValidatedTreeNode validated = modification.validatedNode(this, currentMeta);
        if (validated != null) {
            return validated.treeNode();
        }
        if (this.delegate instanceof AbstractValidation && (validated = modification.validatedNode(this.delegate, currentMeta)) != null) {
            return validated.treeNode();
        }
        TreeNode ret = this.delegate.apply(modification, currentMeta, version);
        if (ret != null) {
            this.enforceOnData(ret.data());
        }
        return ret;
    }

    @Override
    final void checkApplicable(ModificationPath path, NodeModification modification, TreeNode currentMeta, Version version) throws DataValidationFailedException {
        this.delegate.checkApplicable(path, modification, currentMeta, version);
        if (!(modification instanceof ModifiedNode)) {
            LOG.debug("Could not validate {}, does not implement expected class {}", (Object)modification, ModifiedNode.class);
            return;
        }
        ModifiedNode modified = (ModifiedNode)modification;
        if (this.delegate instanceof AbstractValidation) {
            this.checkApplicable(path, ((ValidatedTreeNode)Verify.verifyNotNull((Object)modified.validatedNode(this.delegate, currentMeta))).treeNode());
            return;
        }
        TreeNode applied = this.delegate.apply(modified, currentMeta, version);
        this.checkApplicable(path, applied);
        modified.setValidatedNode(this, currentMeta, applied);
    }

    private void checkApplicable(ModificationPath path, @Nullable TreeNode applied) throws DataValidationFailedException {
        if (applied != null) {
            this.enforceOnData(path, applied.data());
        }
    }

    @Override
    void fullVerifyStructure(NormalizedNode modification) {
        this.delegate.fullVerifyStructure(modification);
        this.enforceOnData(modification);
    }

    final @NonNull ModificationApplyOperation delegate() {
        return this.delegate;
    }

    abstract void enforceOnData(ModificationPath var1, NormalizedNode var2) throws DataValidationFailedException;

    abstract void enforceOnData(@NonNull NormalizedNode var1);

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("delegate", (Object)this.delegate);
    }
}

