/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNodes;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.VersionInfo;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursorAware;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractReadyIterator;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.OperationWithModification;
import org.opendaylight.yangtools.yang.data.tree.impl.RootApplyStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDataTreeModification
extends AbstractCursorAware
implements CursorAwareDataTreeModification {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDataTreeModification.class);
    private static final byte STATE_OPEN = 0;
    private static final byte STATE_SEALING = 1;
    private static final byte STATE_SEALED = 2;
    private static final VarHandle STATE;
    private final RootApplyStrategy strategyTree;
    private final InMemoryDataTreeSnapshot snapshot;
    private final ModifiedNode rootNode;
    private final Version version;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile byte state;

    InMemoryDataTreeModification(InMemoryDataTreeSnapshot snapshot, RootApplyStrategy resolver) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.strategyTree = Objects.requireNonNull(resolver).snapshot();
        this.rootNode = ModifiedNode.createUnmodified(snapshot.getRootNode(), this.getStrategy().getChildPolicy());
        this.version = snapshot.getRootNode().subtreeVersion().next();
    }

    ModifiedNode getRootModification() {
        return this.rootNode;
    }

    ModificationApplyOperation getStrategy() {
        ModificationApplyOperation ret = this.strategyTree.delegate();
        if (ret == null) {
            throw new IllegalStateException("Schema Context is not available.");
        }
        return ret;
    }

    public EffectiveModelContext modelContext() {
        return this.snapshot.modelContext();
    }

    public void write(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkOpen();
        this.checkIdentifierReferencesData(path, data);
        this.resolveModificationFor(path).write(data);
    }

    public void merge(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkOpen();
        this.checkIdentifierReferencesData(path, data);
        this.resolveModificationFor(path).merge(data, this.version);
    }

    public void delete(YangInstanceIdentifier path) {
        this.checkOpen();
        this.resolveModificationFor(path).delete();
    }

    public Optional<NormalizedNode> readNode(YangInstanceIdentifier path) {
        Map.Entry<YangInstanceIdentifier, ModifiedNode> terminal = this.resolveTerminal(path);
        YangInstanceIdentifier terminalPath = terminal.getKey();
        TreeNode result = this.resolveSnapshot(terminalPath, terminal.getValue());
        return result == null ? Optional.empty() : NormalizedNodes.findNode((YangInstanceIdentifier)terminalPath, (NormalizedNode)result.data(), (YangInstanceIdentifier)path);
    }

    public Optional<VersionInfo> readVersionInfo(YangInstanceIdentifier path) {
        Map.Entry<YangInstanceIdentifier, ModifiedNode> terminal = this.resolveTerminal(path);
        YangInstanceIdentifier terminalPath = terminal.getKey();
        TreeNode result = this.resolveSnapshot(terminalPath, terminal.getValue());
        return result == null ? Optional.empty() : StoreTreeNodes.findNode((StoreTreeNode)result, (YangInstanceIdentifier)((YangInstanceIdentifier)path.relativeTo(terminalPath).orElseThrow())).flatMap(treeNode -> Optional.ofNullable(treeNode.subtreeVersion().readInfo()));
    }

    private Map.Entry<YangInstanceIdentifier, ModifiedNode> resolveTerminal(YangInstanceIdentifier path) {
        return StoreTreeNodes.findClosestsOrFirstMatch((StoreTreeNode)this.rootNode, (YangInstanceIdentifier)path, input -> switch (input.getOperation()) {
            default -> throw new MatchException(null, null);
            case LogicalOperation.DELETE, LogicalOperation.MERGE, LogicalOperation.WRITE -> true;
            case LogicalOperation.NONE, LogicalOperation.TOUCH -> false;
        });
    }

    private @Nullable TreeNode resolveSnapshot(YangInstanceIdentifier path, ModifiedNode modification) {
        Optional<TreeNode> potentialSnapshot = modification.getSnapshot();
        if (potentialSnapshot != null) {
            return potentialSnapshot.orElse(null);
        }
        try {
            return this.resolveModificationStrategy(path).apply(modification, modification.original(), this.version);
        }
        catch (Exception e) {
            LOG.error("Could not create snapshot for {}:{}", new Object[]{path, modification, e});
            throw e;
        }
    }

    void upgradeIfPossible() {
        if (this.rootNode.getOperation() == LogicalOperation.NONE) {
            this.strategyTree.upgradeIfPossible();
        }
    }

    private ModificationApplyOperation resolveModificationStrategy(YangInstanceIdentifier path) {
        LOG.trace("Resolving modification apply strategy for {}", (Object)path);
        this.upgradeIfPossible();
        return (ModificationApplyOperation)StoreTreeNodes.findNodeChecked((StoreTreeNode)this.getStrategy(), (YangInstanceIdentifier)path);
    }

    private OperationWithModification resolveModificationFor(YangInstanceIdentifier path) {
        this.upgradeIfPossible();
        ModificationApplyOperation operation = this.getStrategy();
        ModifiedNode modification = this.rootNode;
        int depth = 1;
        for (YangInstanceIdentifier.PathArgument pathArg : path.getPathArguments()) {
            if ((operation = operation.childByArg(pathArg)) == null) {
                throw new SchemaValidationFailedException(String.format("Child %s is not present in schema tree.", path.getAncestor(depth)));
            }
            ++depth;
            modification = modification.modifyChild(pathArg, operation, this.version);
        }
        return OperationWithModification.from(operation, modification);
    }

    public String toString() {
        return "MutableDataTree [modification=" + String.valueOf(this.rootNode) + "]";
    }

    public InMemoryDataTreeModification newModification() {
        Preconditions.checkState((boolean)this.isSealed(), (Object)"Attempted to chain on an unsealed modification");
        if (this.rootNode.getOperation() == LogicalOperation.NONE) {
            return this.snapshot.newModification();
        }
        TreeNode originalSnapshotRoot = this.snapshot.getRootNode();
        TreeNode newRoot = this.getStrategy().apply(this.rootNode, originalSnapshotRoot, this.version);
        if (newRoot == null) {
            throw new IllegalStateException("Data tree root is not present, possibly removed by previous modification");
        }
        return new InMemoryDataTreeSnapshot(this.snapshot.modelContext(), newRoot, this.strategyTree).newModification();
    }

    Version getVersion() {
        return this.version;
    }

    boolean isSealed() {
        return STATE.getAcquire(this) == 2;
    }

    private void checkOpen() {
        byte local = STATE.getAcquire(this);
        if (local != 0) {
            throw new IllegalStateException("Data Tree is sealed. No further modifications allowed in state " + local);
        }
    }

    private static void applyChildren(DataTreeModificationCursor cursor, ModifiedNode node) {
        if (!node.isEmpty()) {
            cursor.enter(node.getIdentifier());
            for (ModifiedNode child : node.getChildren()) {
                InMemoryDataTreeModification.applyNode(cursor, child);
            }
            cursor.exit();
        }
    }

    private static void applyNode(DataTreeModificationCursor cursor, ModifiedNode node) {
        LogicalOperation operation = node.getOperation();
        switch (operation) {
            case NONE: {
                break;
            }
            case DELETE: {
                cursor.delete(node.getIdentifier());
                break;
            }
            case MERGE: {
                cursor.merge(node.getIdentifier(), node.getWrittenValue());
                InMemoryDataTreeModification.applyChildren(cursor, node);
                break;
            }
            case TOUCH: {
                InMemoryDataTreeModification.applyChildren(cursor, node);
                break;
            }
            case WRITE: {
                cursor.write(node.getIdentifier(), node.getWrittenValue());
                InMemoryDataTreeModification.applyChildren(cursor, node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled node operation " + String.valueOf((Object)operation));
            }
        }
    }

    public void applyToCursor(DataTreeModificationCursor cursor) {
        for (ModifiedNode child : this.rootNode.getChildren()) {
            InMemoryDataTreeModification.applyNode(cursor, child);
        }
    }

    static void checkIdentifierReferencesData(YangInstanceIdentifier.PathArgument arg, NormalizedNode data) {
        YangInstanceIdentifier.PathArgument dataName = data.name();
        Preconditions.checkArgument((boolean)arg.equals((Object)dataName), (String)"Instance identifier references %s but data identifier is %s", (Object)arg, (Object)dataName);
    }

    private void checkIdentifierReferencesData(YangInstanceIdentifier path, NormalizedNode data) {
        YangInstanceIdentifier.PathArgument arg;
        if (!path.isEmpty()) {
            arg = path.getLastPathArgument();
            Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (String)"Instance identifier %s has invalid null path argument", (Object)path);
        } else {
            arg = this.rootNode.getIdentifier();
        }
        InMemoryDataTreeModification.checkIdentifierReferencesData(arg, data);
    }

    public Optional<DataTreeModificationCursor> openCursor(YangInstanceIdentifier path) {
        OperationWithModification op = this.resolveModificationFor(path);
        return Optional.of((DataTreeModificationCursor)this.openCursor(new InMemoryDataTreeModificationCursor(this, path, op)));
    }

    public void ready() {
        if (!STATE.compareAndSet(this, (byte)0, (byte)1)) {
            throw new IllegalStateException("Attempted to seal an already-sealed Data Tree.");
        }
        AbstractReadyIterator current = AbstractReadyIterator.create(this.rootNode, this.getStrategy());
        while ((current = current.process(this.version)) != null) {
        }
        STATE.setRelease(this, (byte)2);
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(InMemoryDataTreeModification.class, "state", Byte.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

