/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

sealed class MapEntryModificationStrategy
extends DataNodeContainerModificationStrategy<ListSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> SUPPORT = new NormalizedNodeContainerSupport(MapEntryNode.class, arg_0 -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newMapEntryBuilder(arg_0), () -> ((NormalizedNode.BuilderFactory)BUILDER_FACTORY).newMapEntryBuilder());

    MapEntryModificationStrategy(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(SUPPORT, schema, treeConfig);
    }

    static @NonNull MapEntryModificationStrategy of(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        MandatoryLeafEnforcer enforcer = MapEntryModificationStrategy.enforcerFor((DataSchemaNode)schema, treeConfig);
        return enforcer != null ? new EnforcingMandatory(schema, treeConfig, enforcer) : new MapEntryModificationStrategy(schema, treeConfig);
    }

    private static final class EnforcingMandatory
    extends MapEntryModificationStrategy {
        private final MandatoryLeafEnforcer enforcer;

        EnforcingMandatory(ListSchemaNode schemaNode, DataTreeConfiguration treeConfig, MandatoryLeafEnforcer enforcer) {
            super(schemaNode, treeConfig);
            this.enforcer = Objects.requireNonNull(enforcer);
        }

        @Override
        void mandatoryVerifyValueChildren(DistinctNodeContainer<?, ?> writtenValue) {
            this.enforcer.enforceOnData(writtenValue);
        }

        @Override
        protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
            return this.enforce(super.applyMerge(modification, currentMeta, version));
        }

        @Override
        protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode newValue, TreeNode currentMeta, Version version) {
            return this.enforce(super.applyWrite(modification, newValue, currentMeta, version));
        }

        @Override
        protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
            return this.enforce(super.applyTouch(modification, currentMeta, version));
        }

        private @NonNull TreeNode enforce(TreeNode treeNode) {
            this.enforcer.enforceOnData(treeNode.data());
            return treeNode;
        }
    }
}

