/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNamePredicateImpl;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;

final class QNamePredicateBuilder
implements Mutable {
    private QName identifier;
    private LeafRefPath pathKeyExpression;

    QNamePredicateBuilder() {
    }

    QNamePredicateBuilder(QName identifier, LeafRefPath pathKeyExpression) {
        this.identifier = identifier;
        this.pathKeyExpression = pathKeyExpression;
    }

    public QName getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(QName identifier) {
        this.identifier = identifier;
    }

    public LeafRefPath getPathKeyExpression() {
        return this.pathKeyExpression;
    }

    public void setPathKeyExpression(LeafRefPath pathKeyExpression) {
        this.pathKeyExpression = pathKeyExpression;
    }

    public @NonNull QNamePredicate build() {
        return new QNamePredicateImpl(this.identifier, this.pathKeyExpression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.identifier);
        sb.append("=current()");
        for (QNameWithPredicate qname : this.pathKeyExpression.getPathFromRoot()) {
            sb.append('/').append(qname);
        }
        sb.append(']');
        return sb.toString();
    }
}

