/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.remote.rpc.OpsManager;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.opendaylight.controller.remoterpc"})
@Designate(ocd=Config.class)
public final class OSGiRemoteOpsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiRemoteOpsProvider.class);
    private ActorRef opsManager;

    @Activate
    public OSGiRemoteOpsProvider(@Reference ActorSystemProvider actorSystemProvider, @Reference DOMRpcProviderService rpcProviderService, @Reference DOMRpcService rpcService, @Reference DOMActionProviderService actionProviderService, @Reference DOMActionService actionService, Config config) {
        LOG.info("Remote Operations service starting");
        ActorSystem actorSystem = actorSystemProvider.getActorSystem();
        RemoteOpsProviderConfig opsConfig = RemoteOpsProviderConfig.newInstance(actorSystem.name(), config.metricCapture(), config.boundedMailboxCapacity());
        this.opsManager = actorSystem.actorOf(OpsManager.props(rpcProviderService, rpcService, opsConfig, actionProviderService, actionService), opsConfig.getRpcManagerName());
        LOG.debug("Ops Manager started at {}", (Object)this.opsManager);
        LOG.info("Remote Operations service started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Remote Operations service stopping");
        LOG.debug("Stopping Ops Manager at {}", (Object)this.opsManager);
        this.opsManager.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
        this.opsManager = null;
        LOG.info("Remote Operations services stopped");
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="enable-metric-capture")
        public boolean metricCapture() default true;

        @AttributeDefinition(name="bounded-mailbox-capacity")
        public int boundedMailboxCapacity() default 1000;
    }
}

