/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.remote.rpc.messages.AbstractExecute;
import org.opendaylight.controller.remote.rpc.messages.RpcResponse;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;

public final class ExecuteRpc
extends AbstractExecute<QName, ContainerNode> {
    private static final long serialVersionUID = 1128904894827335676L;

    private ExecuteRpc(@NonNull QName type, @Nullable ContainerNode input) {
        super(type, input);
    }

    public static @NonNull ExecuteRpc from(@NonNull DOMRpcIdentifier rpc, @Nullable ContainerNode input) {
        return new ExecuteRpc(rpc.getType(), input);
    }

    @Override
    Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ExecuteRpc executeRpc;

        public Proxy() {
        }

        Proxy(ExecuteRpc executeRpc) {
            this.executeRpc = Objects.requireNonNull(executeRpc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            try (NormalizedNodeDataOutput stream = NormalizedNodeStreamVersion.current().newDataOutput((DataOutput)out);){
                stream.writeQName((QName)this.executeRpc.getType());
                stream.writeOptionalNormalizedNode(this.executeRpc.getInput());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            NormalizedNodeDataInput stream = NormalizedNodeDataInput.newDataInput((DataInput)in);
            QName type = stream.readQName();
            ContainerNode input = RpcResponse.unmaskContainer(stream.readOptionalNormalizedNode());
            this.executeRpc = new ExecuteRpc(type, input);
        }

        private Object readResolve() {
            return this.executeRpc;
        }
    }
}

