/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.controller.remote.rpc.messages.AbstractResponse;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class RpcResponse
extends AbstractResponse<ContainerNode> {
    private static final long serialVersionUID = -4211279498688989245L;

    public RpcResponse(@Nullable ContainerNode output) {
        super(output);
    }

    @Override
    Object writeReplace() {
        return new Proxy(this);
    }

    static @Nullable ContainerNode unmaskContainer(Optional<NormalizedNode> optNode) throws InvalidObjectException {
        if (optNode.isEmpty()) {
            return null;
        }
        NormalizedNode node = optNode.orElseThrow();
        if (node instanceof ContainerNode) {
            ContainerNode container = (ContainerNode)node;
            return container;
        }
        throw new InvalidObjectException("Unexpected data " + node.contract().getSimpleName());
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private RpcResponse rpcResponse;

        public Proxy() {
        }

        Proxy(RpcResponse rpcResponse) {
            this.rpcResponse = rpcResponse;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            SerializationUtils.writeNormalizedNode((DataOutput)out, this.rpcResponse.getOutput());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.rpcResponse = new RpcResponse(RpcResponse.unmaskContainer(SerializationUtils.readNormalizedNode((DataInput)in)));
        }

        private Object readResolve() {
            return this.rpcResponse;
        }
    }
}

