/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.Props;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.registry.ActionRoutingTable;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreActor;
import org.opendaylight.controller.remote.rpc.registry.mbeans.RemoteActionRegistryMXBeanImpl;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import scala.concurrent.ExecutionContext;

public class ActionRegistry
extends BucketStoreActor<ActionRoutingTable> {
    private final ActorRef rpcRegistrar;
    private RemoteActionRegistryMXBeanImpl mxBean;

    public ActionRegistry(RemoteOpsProviderConfig config, ActorRef rpcInvoker, ActorRef rpcRegistrar) {
        super(config, config.getRpcRegistryPersistenceId(), new ActionRoutingTable(rpcInvoker, (Collection<DOMActionInstance>)ImmutableSet.of()));
        this.rpcRegistrar = Objects.requireNonNull(rpcRegistrar);
    }

    public static Props props(RemoteOpsProviderConfig config, ActorRef opsInvoker, ActorRef opsRegistrar) {
        return Props.create(ActionRegistry.class, (Object[])new Object[]{config, opsInvoker, opsRegistrar});
    }

    @Override
    public void preStart() {
        super.preStart();
        this.mxBean = new RemoteActionRegistryMXBeanImpl(new BucketStoreAccess(this.self(), (ExecutionContext)this.getContext().dispatcher(), this.getConfig().getAskDuration()), this.getConfig().getAskDuration());
    }

    public void postStop() throws Exception {
        if (this.mxBean != null) {
            this.mxBean.unregister();
            this.mxBean = null;
        }
        super.postStop();
    }

    @Override
    protected void handleCommand(Object message) throws Exception {
        if (message instanceof Messages.UpdateActions) {
            Messages.UpdateActions updateActions = (Messages.UpdateActions)message;
            this.LOG.debug("handling updatesActionRoutes message");
            this.updatesActionRoutes(updateActions);
        } else {
            super.handleCommand(message);
        }
    }

    private void updatesActionRoutes(Messages.UpdateActions msg) {
        this.LOG.debug("addedActions: {}", msg.getAddedActions());
        this.LOG.debug("removedActions: {}", msg.getRemovedActions());
        this.updateLocalBucket(((ActionRoutingTable)this.getLocalData()).updateActions(msg.getAddedActions(), msg.getRemovedActions()));
    }

    @Override
    protected void onBucketRemoved(Address address, Bucket<ActionRoutingTable> bucket) {
        this.rpcRegistrar.tell((Object)new Messages.UpdateRemoteActionEndpoints((Map<Address, Optional<RemoteActionEndpoint>>)ImmutableMap.of((Object)address, Optional.empty())), ActorRef.noSender());
    }

    @Override
    protected void onBucketsUpdated(Map<Address, Bucket<ActionRoutingTable>> buckets) {
        this.LOG.debug("Updating buckets for action registry");
        HashMap<Address, Optional<RemoteActionEndpoint>> endpoints = new HashMap<Address, Optional<RemoteActionEndpoint>>(buckets.size());
        Iterator<Map.Entry<Address, Bucket<ActionRoutingTable>>> iterator = buckets.entrySet().iterator();
        while (iterator.hasNext()) {
            ActionRoutingTable table;
            ImmutableSet actions;
            Map.Entry<Address, Bucket<ActionRoutingTable>> e;
            endpoints.put(e.getKey(), (actions = (table = (e = iterator.next()).getValue().getData()).getItems()).isEmpty() ? Optional.empty() : Optional.of(new RemoteActionEndpoint(table.getInvoker(), (Collection<DOMActionInstance>)actions)));
        }
        if (!endpoints.isEmpty()) {
            this.rpcRegistrar.tell((Object)new Messages.UpdateRemoteActionEndpoints(endpoints), ActorRef.noSender());
        }
    }

    public static class Messages {

        public static final class UpdateRemoteActionEndpoints {
            private final Map<Address, Optional<RemoteActionEndpoint>> actionEndpoints;

            @VisibleForTesting
            public UpdateRemoteActionEndpoints(Map<Address, Optional<RemoteActionEndpoint>> actionEndpoints) {
                this.actionEndpoints = ImmutableMap.copyOf(actionEndpoints);
            }

            public Map<Address, Optional<RemoteActionEndpoint>> getActionEndpoints() {
                return this.actionEndpoints;
            }
        }

        public static final class UpdateActions
        extends AbstractActionRouteMessage {
            public UpdateActions(Collection<DOMActionInstance> addedActions, Collection<DOMActionInstance> removedActions) {
                super(addedActions, removedActions);
            }
        }

        static abstract class AbstractActionRouteMessage {
            final Collection<DOMActionInstance> addedActions;
            final Collection<DOMActionInstance> removedActions;

            AbstractActionRouteMessage(Collection<DOMActionInstance> addedActions, Collection<DOMActionInstance> removedActions) {
                this.addedActions = ImmutableList.copyOf(addedActions);
                this.removedActions = ImmutableList.copyOf(removedActions);
            }

            Collection<DOMActionInstance> getAddedActions() {
                return this.addedActions;
            }

            Collection<DOMActionInstance> getRemovedActions() {
                return this.removedActions;
            }

            public String toString() {
                return "ContainsRoute{addedActions=" + String.valueOf(this.addedActions) + " removedActions=" + String.valueOf(this.removedActions) + "}";
            }
        }
    }

    public static final class RemoteActionEndpoint {
        private final Set<DOMActionInstance> actions;
        private final ActorRef router;

        @VisibleForTesting
        public RemoteActionEndpoint(ActorRef router, Collection<DOMActionInstance> actions) {
            this.router = Objects.requireNonNull(router);
            this.actions = ImmutableSet.copyOf(actions);
        }

        public ActorRef getRouter() {
            return this.router;
        }

        public Set<DOMActionInstance> getActions() {
            return this.actions;
        }
    }
}

