/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.gossip;

import com.google.common.base.Verify;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketData;

final class BucketImpl<T extends BucketData<T>>
implements Bucket<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long version;
    private final T data;

    BucketImpl(long version, T data) {
        this.version = version;
        this.data = (BucketData)Objects.requireNonNull(data);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public String toString() {
        return "BucketImpl{version=" + this.version + ", data=" + String.valueOf(this.data) + "}";
    }

    private Object readResolve() {
        Verify.verifyNotNull(this.data);
        return this;
    }
}

