/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.gossip;

import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.Address;
import akka.actor.PoisonPill;
import akka.actor.Terminated;
import akka.cluster.ClusterActorRefProvider;
import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.RecoveryCompleted;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SnapshotOffer;
import akka.persistence.SnapshotSelectionCriteria;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedPersistentActorWithMetering;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketData;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.opendaylight.controller.remote.rpc.registry.gossip.Gossiper;
import org.opendaylight.controller.remote.rpc.registry.gossip.LocalBucket;

public abstract class BucketStoreActor<T extends BucketData<T>>
extends AbstractUntypedPersistentActorWithMetering {
    private final Map<Address, Bucket<T>> remoteBuckets = new HashMap<Address, Bucket<T>>();
    private final Map<Address, Long> versions = new HashMap<Address, Long>();
    private final SetMultimap<ActorRef, Address> watchedActors = HashMultimap.create((int)1, (int)1);
    private final RemoteOpsProviderConfig config;
    private final String persistenceId;
    private Address selfAddress;
    private LocalBucket<T> localBucket;
    private T initialData;
    private Integer incarnation;
    private boolean persisting;

    protected BucketStoreActor(RemoteOpsProviderConfig config, String persistenceId, T initialData) {
        this.config = Objects.requireNonNull(config);
        this.initialData = (BucketData)Objects.requireNonNull(initialData);
        this.persistenceId = Objects.requireNonNull(persistenceId);
    }

    static ExecuteInActor getBucketsByMembersMessage(Collection<Address> members) {
        return actor -> actor.getBucketsByMembers(members);
    }

    static ExecuteInActor removeBucketMessage(Address addr) {
        return actor -> actor.removeBucket(addr);
    }

    static ExecuteInActor updateRemoteBucketsMessage(Map<Address, Bucket<?>> buckets) {
        return actor -> actor.updateRemoteBuckets(buckets);
    }

    static ExecuteInActor getLocalDataMessage() {
        return actor -> actor.getSender().tell(actor.getLocalData(), actor.getSelf());
    }

    static ExecuteInActor getRemoteBucketsMessage() {
        return actor -> actor.getSender().tell((Object)ImmutableMap.copyOf(actor.getRemoteBuckets()), actor.getSelf());
    }

    public final T getLocalData() {
        return this.getLocalBucket().getData();
    }

    public final Map<Address, Bucket<T>> getRemoteBuckets() {
        return this.remoteBuckets;
    }

    public final Map<Address, Long> getVersions() {
        return this.versions;
    }

    public final String persistenceId() {
        return this.persistenceId;
    }

    public void preStart() {
        ActorRefProvider provider = this.getContext().provider();
        this.selfAddress = provider.getDefaultAddress();
        if (provider instanceof ClusterActorRefProvider) {
            this.getContext().actorOf(Gossiper.props(this.config).withMailbox(this.config.getMailBoxName()), "gossiper");
        }
    }

    protected void handleCommand(Object message) throws Exception {
        if (BucketStoreAccess.Singletons.GET_ALL_BUCKETS == message) {
            this.getSender().tell(this.getAllBuckets(), this.self());
            return;
        }
        if (this.persisting) {
            this.handleSnapshotMessage(message);
            return;
        }
        if (BucketStoreAccess.Singletons.GET_BUCKET_VERSIONS == message) {
            this.getSender().tell((Object)ImmutableMap.copyOf(this.versions), this.getSelf());
            return;
        }
        Object object = message;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExecuteInActor.class, Terminated.class, DeleteSnapshotsSuccess.class, DeleteSnapshotsFailure.class}, (Object)object2, n)) {
            case 0: {
                ExecuteInActor execute = (ExecuteInActor)object2;
                execute.accept(this);
                break;
            }
            case 1: {
                Terminated terminated = (Terminated)object2;
                this.actorTerminated(terminated);
                break;
            }
            case 2: {
                DeleteSnapshotsSuccess deleteSuccess = (DeleteSnapshotsSuccess)object2;
                this.LOG.debug("{}: got command: {}", (Object)this.persistenceId(), (Object)deleteSuccess);
                break;
            }
            case 3: {
                DeleteSnapshotsFailure deleteFailure = (DeleteSnapshotsFailure)object2;
                this.LOG.warn("{}: failed to delete prior snapshots", (Object)this.persistenceId(), (Object)deleteFailure.cause());
                break;
            }
            default: {
                this.LOG.debug("Unhandled message [{}]", message);
                this.unhandled(message);
            }
        }
    }

    private void handleSnapshotMessage(Object message) {
        Object object = message;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SaveSnapshotFailure.class, SaveSnapshotSuccess.class}, (Object)object2, n)) {
            case 0: {
                SaveSnapshotFailure saveFailure = (SaveSnapshotFailure)object2;
                this.LOG.error("{}: failed to persist state", (Object)this.persistenceId(), (Object)saveFailure.cause());
                this.persisting = false;
                this.self().tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
                break;
            }
            case 1: {
                SaveSnapshotSuccess saveSuccess = (SaveSnapshotSuccess)object2;
                this.LOG.debug("{}: got command: {}", (Object)this.persistenceId(), (Object)saveSuccess);
                this.deleteSnapshots(new SnapshotSelectionCriteria(scala.Long.MaxValue(), saveSuccess.metadata().timestamp() - 1L, 0L, 0L));
                this.persisting = false;
                this.unstash();
                break;
            }
            default: {
                this.LOG.debug("{}: stashing command {}", (Object)this.persistenceId(), message);
                this.stash();
            }
        }
    }

    protected final void handleRecover(Object message) {
        Object object = message;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RecoveryCompleted.class, SnapshotOffer.class}, (Object)object2, n)) {
            case 0: {
                RecoveryCompleted msg = (RecoveryCompleted)object2;
                this.onRecoveryCompleted(msg);
                break;
            }
            case 1: {
                SnapshotOffer msg = (SnapshotOffer)object2;
                this.onSnapshotOffer(msg);
                break;
            }
            default: {
                this.LOG.warn("{}: ignoring recovery message {}", (Object)this.persistenceId(), message);
            }
        }
    }

    private void onRecoveryCompleted(RecoveryCompleted msg) {
        Integer prev = this.incarnation;
        int current = prev != null ? this.incarnation + 1 : 0;
        this.localBucket = new LocalBucket<T>(current, this.initialData);
        this.incarnation = current;
        this.initialData = null;
        this.LOG.debug("{}: persisting new incarnation {}", (Object)this.persistenceId(), (Object)this.incarnation);
        this.persisting = true;
        this.saveSnapshot(this.incarnation);
    }

    private void onSnapshotOffer(SnapshotOffer msg) {
        this.incarnation = (Integer)msg.snapshot();
        this.LOG.debug("{}: recovered incarnation {}", (Object)this.persistenceId(), (Object)this.incarnation);
    }

    protected final RemoteOpsProviderConfig getConfig() {
        return this.config;
    }

    protected final void updateLocalBucket(T data) {
        LocalBucket<T> local = this.getLocalBucket();
        boolean bumpIncarnation = local.setData(data);
        this.versions.put(this.selfAddress, local.getVersion());
        if (bumpIncarnation) {
            this.LOG.debug("Version wrapped. incrementing incarnation");
            Verify.verify((this.incarnation < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Ran out of incarnations, cannot continue", (Object[])new Object[0]);
            this.incarnation = this.incarnation + 1;
            this.persisting = true;
            this.saveSnapshot(this.incarnation);
        }
    }

    protected abstract void onBucketRemoved(Address var1, Bucket<T> var2);

    protected abstract void onBucketsUpdated(Map<Address, Bucket<T>> var1);

    private Map<Address, Bucket<T>> getAllBuckets() {
        HashMap<Address, Bucket<T>> all = new HashMap<Address, Bucket<T>>(this.remoteBuckets.size() + 1);
        all.put(this.selfAddress, this.getLocalBucket().snapshot());
        all.putAll(this.remoteBuckets);
        return all;
    }

    private void getBucketsByMembers(Collection<Address> members) {
        HashMap<Address, Bucket<T>> buckets = new HashMap<Address, Bucket<T>>();
        if (members.contains(this.selfAddress)) {
            buckets.put(this.selfAddress, this.getLocalBucket().snapshot());
        }
        for (Address address : members) {
            if (!this.remoteBuckets.containsKey(address)) continue;
            buckets.put(address, this.remoteBuckets.get(address));
        }
        this.getSender().tell(buckets, this.getSelf());
    }

    private void removeBucket(Address addr) {
        Bucket<T> bucket = this.remoteBuckets.remove(addr);
        if (bucket != null) {
            bucket.getWatchActor().ifPresent(ref -> this.removeWatch(addr, (ActorRef)ref));
            this.onBucketRemoved(addr, bucket);
        }
        this.versions.remove(addr);
    }

    @VisibleForTesting
    void updateRemoteBuckets(Map<Address, Bucket<?>> receivedBuckets) {
        this.LOG.debug("{}: receiveUpdateRemoteBuckets: {}", (Object)this.selfAddress, receivedBuckets);
        if (receivedBuckets == null || receivedBuckets.isEmpty()) {
            return;
        }
        HashMap<Address, Bucket<T>> newBuckets = new HashMap<Address, Bucket<T>>(receivedBuckets.size());
        for (Map.Entry<Address, Bucket<?>> entry : receivedBuckets.entrySet()) {
            Address addr = entry.getKey();
            if (this.selfAddress.equals((Object)addr)) continue;
            Bucket<?> receivedBucket = entry.getValue();
            if (receivedBucket == null) {
                this.LOG.debug("Ignoring null bucket from {}", (Object)addr);
                continue;
            }
            long remoteVersion = receivedBucket.getVersion();
            Long localVersion = this.versions.get(addr);
            if (localVersion != null && remoteVersion <= localVersion) {
                this.LOG.debug("Ignoring down-versioned bucket from {} ({} local {} remote)", new Object[]{addr, localVersion, remoteVersion});
                continue;
            }
            newBuckets.put(addr, receivedBucket);
            this.versions.put(addr, remoteVersion);
            Bucket<?> prevBucket = this.remoteBuckets.put(addr, receivedBucket);
            Optional<Object> prevRef = prevBucket != null ? prevBucket.getWatchActor() : Optional.empty();
            Optional<ActorRef> curRef = receivedBucket.getWatchActor();
            if (!curRef.equals(prevRef)) {
                prevRef.ifPresent(ref -> this.removeWatch(addr, (ActorRef)ref));
                curRef.ifPresent(ref -> this.addWatch(addr, (ActorRef)ref));
            }
            this.LOG.debug("Updating bucket from {} to version {}", (Object)entry.getKey(), (Object)remoteVersion);
        }
        this.LOG.debug("State after update - Local Bucket [{}], Remote Buckets [{}]", this.localBucket, this.remoteBuckets);
        this.onBucketsUpdated(newBuckets);
    }

    private void addWatch(Address addr, ActorRef ref) {
        if (!this.watchedActors.containsKey((Object)ref)) {
            this.getContext().watch(ref);
            this.LOG.debug("Watching {}", (Object)ref);
        }
        this.watchedActors.put((Object)ref, (Object)addr);
    }

    private void removeWatch(Address addr, ActorRef ref) {
        this.watchedActors.remove((Object)ref, (Object)addr);
        if (!this.watchedActors.containsKey((Object)ref)) {
            this.getContext().unwatch(ref);
            this.LOG.debug("No longer watching {}", (Object)ref);
        }
    }

    private void actorTerminated(Terminated message) {
        this.LOG.info("Actor termination {} received", (Object)message);
        for (Address addr : this.watchedActors.removeAll((Object)message.getActor())) {
            this.versions.remove(addr);
            Bucket<T> bucket = this.remoteBuckets.remove(addr);
            if (bucket == null) continue;
            this.LOG.debug("Source actor dead, removing bucket {} from {}", bucket, (Object)addr);
            this.onBucketRemoved(addr, bucket);
        }
    }

    @VisibleForTesting
    protected boolean isPersisting() {
        return this.persisting;
    }

    private LocalBucket<T> getLocalBucket() {
        Preconditions.checkState((this.localBucket != null ? 1 : 0) != 0, (Object)"Attempted to access local bucket before recovery completed");
        return this.localBucket;
    }

    @FunctionalInterface
    private static interface ExecuteInActor
    extends Consumer<BucketStoreActor<?>> {
    }
}

