/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.mbeans;

import akka.util.Timeout;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.remote.rpc.registry.RoutingTable;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.opendaylight.controller.remote.rpc.registry.mbeans.AbstractRegistryMXBean;
import org.opendaylight.controller.remote.rpc.registry.mbeans.RemoteRpcRegistryMXBean;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;

public class RemoteRpcRegistryMXBeanImpl
extends AbstractRegistryMXBean<RoutingTable, DOMRpcIdentifier>
implements RemoteRpcRegistryMXBean {
    public RemoteRpcRegistryMXBeanImpl(BucketStoreAccess rpcRegistryAccess, Timeout timeout) {
        super("RemoteRpcRegistry", "RemoteRpcBroker", rpcRegistryAccess, timeout);
    }

    @Override
    public Set<String> getGlobalRpc() {
        RoutingTable table = (RoutingTable)this.localData();
        HashSet<String> globalRpc = new HashSet<String>(table.getItems().size());
        for (DOMRpcIdentifier route : table.getItems()) {
            if (!route.getContextReference().isEmpty()) continue;
            globalRpc.add(route.getType().toString());
        }
        this.log.debug("Locally registered global RPCs {}", globalRpc);
        return globalRpc;
    }

    @Override
    public Set<String> getLocalRegisteredRoutedRpc() {
        RoutingTable table = (RoutingTable)this.localData();
        HashSet<String> routedRpc = new HashSet<String>(table.getItems().size());
        for (DOMRpcIdentifier route : table.getItems()) {
            if (route.getContextReference().isEmpty()) continue;
            routedRpc.add("route:" + String.valueOf(route.getContextReference()) + " | name:" + String.valueOf(route.getType()));
        }
        this.log.debug("Locally registered routed RPCs {}", routedRpc);
        return routedRpc;
    }

    @Override
    public Map<String, String> findRpcByName(String name) {
        RoutingTable localTable = (RoutingTable)this.localData();
        HashMap<String, String> rpcMap = new HashMap<String, String>(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByName(localTable, name, "local"));
        Map buckets = this.remoteBuckets();
        for (Map.Entry entry : buckets.entrySet()) {
            RoutingTable table = (RoutingTable)entry.getValue().getData();
            rpcMap.putAll(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByName(table, name, entry.getKey().toString()));
        }
        this.log.debug("list of RPCs {} searched by name {}", rpcMap, (Object)name);
        return rpcMap;
    }

    @Override
    public Map<String, String> findRpcByRoute(String routeId) {
        RoutingTable localTable = (RoutingTable)this.localData();
        HashMap<String, String> rpcMap = new HashMap<String, String>(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByRoute(localTable, routeId, "local"));
        Map buckets = this.remoteBuckets();
        for (Map.Entry entry : buckets.entrySet()) {
            RoutingTable table = (RoutingTable)entry.getValue().getData();
            rpcMap.putAll(RemoteRpcRegistryMXBeanImpl.getRpcMemberMapByRoute(table, routeId, entry.getKey().toString()));
        }
        this.log.debug("list of RPCs {} searched by route {}", rpcMap, (Object)routeId);
        return rpcMap;
    }

    private static Map<String, String> getRpcMemberMapByRoute(RoutingTable table, String routeName, String address) {
        ImmutableSet routes = table.getItems();
        HashMap<String, String> rpcMap = new HashMap<String, String>(routes.size());
        for (DOMRpcIdentifier route : routes) {
            String routeString;
            if (route.getContextReference().isEmpty() || !(routeString = route.getContextReference().toString()).contains(routeName)) continue;
            rpcMap.put("route:" + routeString + " | name:" + String.valueOf(route.getType()), address);
        }
        return rpcMap;
    }

    private static Map<String, String> getRpcMemberMapByName(RoutingTable table, String name, String address) {
        ImmutableSet routes = table.getItems();
        HashMap<String, String> rpcMap = new HashMap<String, String>(routes.size());
        for (DOMRpcIdentifier route : routes) {
            String type;
            if (route.getContextReference().isEmpty() || !(type = route.getType().toString()).contains(name)) continue;
            rpcMap.put("route:" + String.valueOf(route.getContextReference()) + " | name:" + type, address);
        }
        return rpcMap;
    }

    @Override
    public String getBucketVersions() {
        return this.bucketVersions();
    }
}

