/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;

public class TermReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int read(UnsafeBuffer termBuffer, int termOffset, FragmentHandler handler, int fragmentsLimit, Header header, ErrorHandler errorHandler, long currentPosition, Position subscriberPosition) {
        int fragmentsRead = 0;
        int offset = termOffset;
        int capacity = termBuffer.capacity();
        header.buffer((DirectBuffer)termBuffer);
        try {
            while (fragmentsRead < fragmentsLimit && offset < capacity) {
                int frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, offset);
                if (frameLength <= 0) {
                    break;
                }
                int frameOffset = offset;
                offset += BitUtil.align((int)frameLength, (int)32);
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                ++fragmentsRead;
                header.offset(frameOffset);
                handler.onFragment((DirectBuffer)termBuffer, frameOffset + 32, frameLength - 32, header);
            }
        }
        catch (Exception ex) {
            errorHandler.onError((Throwable)ex);
        }
        finally {
            long newPosition = currentPosition + (long)(offset - termOffset);
            if (newPosition > currentPosition) {
                subscriberPosition.setOrdered(newPosition);
            }
        }
        return fragmentsRead;
    }

    public static long read(UnsafeBuffer termBuffer, int termOffset, FragmentHandler handler, int fragmentsLimit, Header header, ErrorHandler errorHandler) {
        int fragmentsRead = 0;
        int offset = termOffset;
        int capacity = termBuffer.capacity();
        header.buffer((DirectBuffer)termBuffer);
        try {
            int frameLength;
            while (fragmentsRead < fragmentsLimit && offset < capacity && (frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, offset)) > 0) {
                int frameOffset = offset;
                offset += BitUtil.align((int)frameLength, (int)32);
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                ++fragmentsRead;
                header.offset(frameOffset);
                handler.onFragment((DirectBuffer)termBuffer, frameOffset + 32, frameLength - 32, header);
            }
        }
        catch (Exception ex) {
            errorHandler.onError((Throwable)ex);
        }
        return TermReader.pack(offset, fragmentsRead);
    }

    public static long pack(int offset, int fragmentsRead) {
        return (long)offset << 32 | (long)fragmentsRead;
    }

    public static int fragmentsRead(long readOutcome) {
        return (int)readOutcome;
    }

    public static int offset(long readOutcome) {
        return (int)(readOutcome >>> 32);
    }
}

