/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int.Item;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int.ItemKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class ItemBuilder {
    private Integer _number;
    private ItemKey key;
    Map<Class<? extends Augmentation<Item>>, Augmentation<Item>> augmentation = Map.of();

    public ItemBuilder() {
    }

    public ItemBuilder(Item base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Item>>, Augmentation<Item>>(aug);
        }
        this.key = base.key();
        this._number = base.getNumber();
    }

    public ItemKey key() {
        return this.key;
    }

    public Integer getNumber() {
        return this._number;
    }

    public <E$$ extends Augmentation<Item>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ItemBuilder withKey(ItemKey key) {
        this.key = key;
        return this;
    }

    public ItemBuilder setNumber(Integer value) {
        this._number = value;
        return this;
    }

    public ItemBuilder addAugmentation(Augmentation<Item> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Item>>, Augmentation<Item>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ItemBuilder removeAugmentation(Class<? extends Augmentation<Item>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Item build() {
        return new ItemImpl(this);
    }

    private static final class ItemImpl
    extends AbstractEntryObject<Item, ItemKey>
    implements Item {
        private final Integer _number;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ItemImpl(ItemBuilder base) {
            super(base.augmentation, (Key)ItemImpl.extractKey(base));
            ItemKey key = (ItemKey)this.key();
            this._number = key.getNumber();
        }

        private static @NonNull ItemKey extractKey(ItemBuilder base) {
            ItemKey key = base.key();
            return key != null ? key : new ItemKey(base.getNumber());
        }

        @Override
        public Integer getNumber() {
            return this._number;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Item.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Item.bindingEquals(this, obj);
        }

        public String toString() {
            return Item.bindingToString(this);
        }
    }
}

