/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDeclaration;

public final class StatementDeclarations {
    private StatementDeclarations() {
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull StatementDeclaration.InText inText(int startLine, int startColumn) {
        return StatementDeclarations.canUseShort(startLine, startColumn) ? new InTextShort((short)startLine, (short)startColumn) : new InTextInt(startLine, startColumn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull StatementDeclaration.InText inText(@Nullable String fileName, int startLine, int startColumn) {
        if (fileName == null) {
            return StatementDeclarations.inText(startLine, startColumn);
        }
        Preconditions.checkArgument((!fileName.isEmpty() ? 1 : 0) != 0, (Object)"Invalid empty file name");
        return StatementDeclarations.canUseShort(startLine, startColumn) ? new InTextFileShort(fileName, (short)startLine, (short)startColumn) : new InTextFileInt(fileName, startLine, startColumn);
    }

    private static boolean canUseShort(int startLine, int startColumn) {
        Preconditions.checkArgument((startLine > 0 ? 1 : 0) != 0, (String)"Invalid start line %s", (int)startLine);
        Preconditions.checkArgument((startColumn > 0 ? 1 : 0) != 0, (String)"Invalid start column %s", (int)startColumn);
        return startLine <= 65535 && startColumn <= 65535;
    }

    private static class InTextShort
    extends StatementDeclaration.InText {
        private final short startLine;
        private final short startColumn;

        InTextShort(short startLine, short startColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
        }

        public int startLine() {
            return Short.toUnsignedInt(this.startLine);
        }

        public int startColumn() {
            return Short.toUnsignedInt(this.startColumn);
        }
    }

    private static class InTextInt
    extends StatementDeclaration.InText {
        private final int startLine;
        private final int startColumn;

        InTextInt(int startLine, int startColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
        }

        public int startLine() {
            return this.startLine;
        }

        public int startColumn() {
            return this.startColumn;
        }
    }

    private static final class InTextFileShort
    extends StatementDeclaration.InTextFile {
        private final @NonNull String fileName;
        private final short startLine;
        private final short startColumn;

        InTextFileShort(String fileName, short startLine, short startColumn) {
            this.fileName = Objects.requireNonNull(fileName);
            this.startLine = startLine;
            this.startColumn = startColumn;
        }

        public int startLine() {
            return Short.toUnsignedInt(this.startLine);
        }

        public int startColumn() {
            return Short.toUnsignedInt(this.startColumn);
        }

        public String fileName() {
            return this.fileName;
        }
    }

    private static final class InTextFileInt
    extends StatementDeclaration.InTextFile {
        private final @NonNull String fileName;
        private final int startLine;
        private final int startColumn;

        InTextFileInt(String fileName, int startLine, int startColumn) {
            this.fileName = Objects.requireNonNull(fileName);
            this.startLine = startLine;
            this.startColumn = startColumn;
        }

        public int startLine() {
            return this.startLine;
        }

        public int startColumn() {
            return this.startColumn;
        }

        public String fileName() {
            return this.fileName;
        }
    }
}

