/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.data.codec.osgi.OSGiBindingDOMCodecServices;
import org.opendaylight.yangtools.binding.data.codec.spi.BindingDOMCodecServices;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(factory="org.opendaylight.mdsal.binding.dom.codec.osgi.impl.OSGiBindingDOMCodecServicesImpl", service={OSGiBindingDOMCodecServices.class})
public final class OSGiBindingDOMCodecServicesImpl
implements OSGiBindingDOMCodecServices {
    static final String FACTORY_NAME = "org.opendaylight.mdsal.binding.dom.codec.osgi.impl.OSGiBindingDOMCodecServicesImpl";
    @VisibleForTesting
    static final String GENERATION = "org.opendaylight.mdsal.binding.dom.codec.osgi.impl.Generation";
    @VisibleForTesting
    static final String DELEGATE = "org.opendaylight.mdsal.binding.dom.codec.osgi.impl.BindingDOMCodecServices";
    private static final Logger LOG = LoggerFactory.getLogger(OSGiBindingDOMCodecServicesImpl.class);
    private BindingDOMCodecServices delegate;
    private final Uint64 generation;

    @Activate
    public OSGiBindingDOMCodecServicesImpl(Map<String, ?> properties) {
        this.generation = (Uint64)Verify.verifyNotNull(properties.get(GENERATION));
        this.delegate = (BindingDOMCodecServices)Verify.verifyNotNull(properties.get(DELEGATE));
        LOG.info("Binding/DOM Codec generation {} activated", (Object)this.generation);
    }

    public Uint64 generation() {
        return this.generation;
    }

    public BindingDOMCodecServices service() {
        return (BindingDOMCodecServices)Verify.verifyNotNull((Object)this.delegate);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("Binding/DOM Codec generation {} deactivated", (Object)this.generation);
    }

    static Dictionary<String, ?> props(@NonNull Uint64 generation, @NonNull Integer ranking, @NonNull BindingDOMCodecServices delegate) {
        return FrameworkUtil.asDictionary(Map.of("service.ranking", ranking, GENERATION, generation, DELEGATE, delegate));
    }
}

